/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.Console;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NoChargeException;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.event.player.PlayerTeleportEvent;

public class Commandtp
extends EssentialsCommand {
    public Commandtp() {
        super("tp");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        CompletableFuture<Boolean> future = this.getNewExceptionFuture(user.getSource(), commandLabel);
        switch (args.length) {
            case 0: {
                throw new NotEnoughArgumentsException();
            }
            case 1: {
                User player = this.getPlayer(server, user, args, 0, false, true);
                if (!player.isTeleportEnabled()) {
                    throw new Exception(I18n.tl("teleportDisabled", player.getDisplayName()));
                }
                if (!player.getBase().isOnline() && user.isAuthorized("essentials.tpoffline")) {
                    throw new Exception(I18n.tl("teleportOffline", player.getDisplayName()));
                }
                if (user.getWorld() != player.getWorld() && this.ess.getSettings().isWorldTeleportPermissions() && !user.isAuthorized("essentials.worlds." + player.getWorld().getName())) {
                    throw new Exception(I18n.tl("noPerm", "essentials.worlds." + player.getWorld().getName()));
                }
                Trade charge = new Trade(this.getName(), this.ess);
                charge.isAffordableFor(user);
                user.getAsyncTeleport().teleport(player.getBase(), charge, PlayerTeleportEvent.TeleportCause.COMMAND, future);
                throw new NoChargeException();
            }
            case 3: {
                double z2;
                double y2;
                double x2;
                if (!user.isAuthorized("essentials.tp.position")) {
                    throw new Exception(I18n.tl("noPerm", "essentials.tp.position"));
                }
                double d = args[0].startsWith("~") ? user.getLocation().getX() + (args[0].length() > 1 ? Double.parseDouble(args[0].substring(1)) : 0.0) : (x2 = Double.parseDouble(args[0]));
                double d2 = args[1].startsWith("~") ? user.getLocation().getY() + (args[1].length() > 1 ? Double.parseDouble(args[1].substring(1)) : 0.0) : (y2 = Double.parseDouble(args[1]));
                double d3 = args[2].startsWith("~") ? user.getLocation().getZ() + (args[2].length() > 1 ? Double.parseDouble(args[2].substring(1)) : 0.0) : (z2 = Double.parseDouble(args[2]));
                if (x2 > 3.0E7 || y2 > 3.0E7 || z2 > 3.0E7 || x2 < -3.0E7 || y2 < -3.0E7 || z2 < -3.0E7) {
                    throw new NotEnoughArgumentsException(I18n.tl("teleportInvalidLocation", new Object[0]));
                }
                Location locpos = new Location(user.getWorld(), x2, y2, z2, user.getLocation().getYaw(), user.getLocation().getPitch());
                user.getAsyncTeleport().now(locpos, false, PlayerTeleportEvent.TeleportCause.COMMAND, future);
                future.thenAccept(success -> {
                    if (success.booleanValue()) {
                        user.sendMessage(I18n.tl("teleporting", locpos.getWorld().getName(), locpos.getBlockX(), locpos.getBlockY(), locpos.getBlockZ()));
                    }
                });
                break;
            }
            case 4: {
                double z;
                double y;
                double x;
                if (!user.isAuthorized("essentials.tp.others")) {
                    throw new Exception(I18n.tl("noPerm", "essentials.tp.others"));
                }
                if (!user.isAuthorized("essentials.tp.position")) {
                    throw new Exception(I18n.tl("noPerm", "essentials.tp.position"));
                }
                User target2 = this.getPlayer(server, user, args, 0);
                double d = args[1].startsWith("~") ? target2.getLocation().getX() + (args[1].length() > 1 ? Double.parseDouble(args[1].substring(1)) : 0.0) : (x = Double.parseDouble(args[1]));
                double d4 = args[2].startsWith("~") ? target2.getLocation().getY() + (args[2].length() > 1 ? Double.parseDouble(args[2].substring(1)) : 0.0) : (y = Double.parseDouble(args[2]));
                double d5 = args[3].startsWith("~") ? target2.getLocation().getZ() + (args[3].length() > 1 ? Double.parseDouble(args[3].substring(1)) : 0.0) : (z = Double.parseDouble(args[3]));
                if (x > 3.0E7 || y > 3.0E7 || z > 3.0E7 || x < -3.0E7 || y < -3.0E7 || z < -3.0E7) {
                    throw new NotEnoughArgumentsException(I18n.tl("teleportInvalidLocation", new Object[0]));
                }
                Location locposother = new Location(target2.getWorld(), x, y, z, target2.getLocation().getYaw(), target2.getLocation().getPitch());
                if (!target2.isTeleportEnabled()) {
                    throw new Exception(I18n.tl("teleportDisabled", target2.getDisplayName()));
                }
                user.sendMessage(I18n.tl("teleporting", locposother.getWorld().getName(), locposother.getBlockX(), locposother.getBlockY(), locposother.getBlockZ()));
                target2.getAsyncTeleport().now(locposother, false, PlayerTeleportEvent.TeleportCause.COMMAND, future);
                future.thenAccept(success -> {
                    if (success.booleanValue()) {
                        target2.sendMessage(I18n.tl("teleporting", locposother.getWorld().getName(), locposother.getBlockX(), locposother.getBlockY(), locposother.getBlockZ()));
                    }
                });
                break;
            }
            default: {
                if (!user.isAuthorized("essentials.tp.others")) {
                    throw new Exception(I18n.tl("noPerm", "essentials.tp.others"));
                }
                User target = this.getPlayer(server, user, args, 0);
                User toPlayer = this.getPlayer(server, user, args, 1);
                if (!target.isTeleportEnabled()) {
                    throw new Exception(I18n.tl("teleportDisabled", target.getDisplayName()));
                }
                if (!toPlayer.isTeleportEnabled()) {
                    throw new Exception(I18n.tl("teleportDisabled", toPlayer.getDisplayName()));
                }
                if (target.getWorld() != toPlayer.getWorld() && this.ess.getSettings().isWorldTeleportPermissions() && !user.isAuthorized("essentials.worlds." + toPlayer.getWorld().getName())) {
                    throw new Exception(I18n.tl("noPerm", "essentials.worlds." + toPlayer.getWorld().getName()));
                }
                target.sendMessage(I18n.tl("teleportAtoB", user.getDisplayName(), toPlayer.getDisplayName()));
                target.getAsyncTeleport().now(toPlayer.getBase(), false, PlayerTeleportEvent.TeleportCause.COMMAND, future);
            }
        }
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 2) {
            throw new NotEnoughArgumentsException();
        }
        User target = this.getPlayer(server, args, 0, true, false);
        if (args.length == 2) {
            User toPlayer = this.getPlayer(server, args, 1, true, false);
            target.sendMessage(I18n.tl("teleportAtoB", Console.DISPLAY_NAME, toPlayer.getDisplayName()));
            target.getAsyncTeleport().now(toPlayer.getBase(), false, PlayerTeleportEvent.TeleportCause.COMMAND, this.getNewExceptionFuture(sender, commandLabel));
        } else if (args.length > 3) {
            double z;
            double y;
            double x;
            double d = args[1].startsWith("~") ? target.getLocation().getX() + (args[1].length() > 1 ? Double.parseDouble(args[1].substring(1)) : 0.0) : (x = Double.parseDouble(args[1]));
            double d2 = args[2].startsWith("~") ? target.getLocation().getY() + (args[2].length() > 1 ? Double.parseDouble(args[2].substring(1)) : 0.0) : (y = Double.parseDouble(args[2]));
            double d3 = args[3].startsWith("~") ? target.getLocation().getZ() + (args[3].length() > 1 ? Double.parseDouble(args[3].substring(1)) : 0.0) : (z = Double.parseDouble(args[3]));
            if (x > 3.0E7 || y > 3.0E7 || z > 3.0E7 || x < -3.0E7 || y < -3.0E7 || z < -3.0E7) {
                throw new NotEnoughArgumentsException(I18n.tl("teleportInvalidLocation", new Object[0]));
            }
            Location loc = new Location(target.getWorld(), x, y, z, target.getLocation().getYaw(), target.getLocation().getPitch());
            sender.sendMessage(I18n.tl("teleporting", loc.getWorld().getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
            CompletableFuture<Boolean> future = this.getNewExceptionFuture(sender, commandLabel);
            target.getAsyncTeleport().now(loc, false, PlayerTeleportEvent.TeleportCause.COMMAND, future);
            future.thenAccept(success -> {
                if (success.booleanValue()) {
                    target.sendMessage(I18n.tl("teleporting", loc.getWorld().getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
                }
            });
        } else {
            throw new NotEnoughArgumentsException();
        }
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1 || args.length == 2 && user.isAuthorized("essentials.tp.others")) {
            return this.getPlayers(server, user);
        }
        return Collections.emptyList();
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1 || args.length == 2) {
            return this.getPlayers(server, sender);
        }
        return Collections.emptyList();
    }
}

