/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import java.util.Collections;
import java.util.List;
import net.ess3.api.events.TPARequestEvent;
import org.bukkit.Server;
import org.bukkit.event.Event;

public class Commandtpahere
extends EssentialsCommand {
    public Commandtpahere() {
        super("tpahere");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        User player = this.getPlayer(server, user, args, 0);
        if (user.getName().equalsIgnoreCase(player.getName())) {
            throw new NotEnoughArgumentsException();
        }
        if (!player.isAuthorized("essentials.tpaccept")) {
            throw new Exception(I18n.tl("teleportNoAcceptPermission", player.getDisplayName()));
        }
        if (!player.isTeleportEnabled()) {
            throw new Exception(I18n.tl("teleportDisabled", player.getDisplayName()));
        }
        if (user.getWorld() != player.getWorld() && this.ess.getSettings().isWorldTeleportPermissions() && !user.isAuthorized("essentials.worlds." + user.getWorld().getName())) {
            throw new Exception(I18n.tl("noPerm", "essentials.worlds." + user.getWorld().getName()));
        }
        if (user.getConfigUUID().equals(player.getTeleportRequest()) && player.hasOutstandingTeleportRequest() && player.isTpRequestHere()) {
            throw new Exception(I18n.tl("requestSentAlready", player.getDisplayName()));
        }
        if (!player.isIgnoredPlayer(user)) {
            TPARequestEvent tpaEvent = new TPARequestEvent(user.getSource(), player, true);
            this.ess.getServer().getPluginManager().callEvent((Event)tpaEvent);
            if (tpaEvent.isCancelled()) {
                throw new Exception(I18n.tl("teleportRequestCancelled", player.getDisplayName()));
            }
            player.requestTeleport(user, true);
            player.sendMessage(I18n.tl("teleportHereRequest", user.getDisplayName()));
            player.sendMessage(I18n.tl("typeTpaccept", new Object[0]));
            player.sendMessage(I18n.tl("typeTpdeny", new Object[0]));
            if (this.ess.getSettings().getTpaAcceptCancellation() != 0L) {
                player.sendMessage(I18n.tl("teleportRequestTimeoutInfo", this.ess.getSettings().getTpaAcceptCancellation()));
            }
        }
        user.sendMessage(I18n.tl("requestSent", player.getDisplayName()));
        user.sendMessage(I18n.tl("typeTpacancel", new Object[0]));
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, user);
        }
        return Collections.emptyList();
    }
}

