/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.items;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.EssentialsConf;
import com.earth2me.essentials.IConf;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ess3.api.IItemDb;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class CustomItemResolver
implements IItemDb.ItemResolver,
IConf {
    private final EssentialsConf config;
    private final Essentials ess;
    private final HashMap<String, String> map = new HashMap();

    public CustomItemResolver(Essentials ess) {
        this.config = new EssentialsConf(new File(ess.getDataFolder(), "custom_items.yml"));
        this.ess = ess;
        this.config.setTemplateName("/custom_items.yml");
    }

    @Override
    public ItemStack apply(String item) {
        if (this.map.containsKey(item)) {
            try {
                return this.ess.getItemDb().get(this.map.get(item));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Collection<String> getNames() {
        return this.map.keySet();
    }

    public List<String> getAliasesFor(String item) throws Exception {
        ArrayList<String> results = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            if (!item.equalsIgnoreCase(this.ess.getItemDb().name(this.ess.getItemDb().get(entry.getValue())))) continue;
            results.add(entry.getKey());
        }
        return results;
    }

    @Override
    public void reloadConfig() {
        this.map.clear();
        this.config.load();
        ConfigurationSection section = this.config.getConfigurationSection("aliases");
        if (section == null || section.getKeys(false).isEmpty()) {
            this.ess.getLogger().warning("No aliases found in custom_items.yml.");
            return;
        }
        for (String alias : section.getKeys(false)) {
            String target;
            if (!section.isString(alias) || (target = section.getString(alias)) == null || section.contains(target) || !this.existsInItemDb(target)) continue;
            this.map.put(alias, target);
        }
    }

    public void setAlias(String alias, String target) {
        if (this.map.containsKey(alias) && this.map.get(alias).equalsIgnoreCase(target)) {
            return;
        }
        this.map.put(alias, target);
        this.save();
    }

    public void removeAlias(String alias) {
        if (this.map.remove(alias) != null) {
            this.save();
        }
    }

    private void save() {
        this.config.setProperty("aliases", this.map);
        this.config.save();
    }

    private boolean existsInItemDb(String item) {
        try {
            this.ess.getItemDb().get(item);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

