/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.messaging;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IEssentials;
import com.earth2me.essentials.IUser;
import com.earth2me.essentials.User;
import com.earth2me.essentials.messaging.IMessageRecipient;
import java.lang.ref.WeakReference;
import net.ess3.api.events.PrivateMessagePreSendEvent;
import net.ess3.api.events.PrivateMessageSentEvent;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class SimpleMessageRecipient
implements IMessageRecipient {
    private final IEssentials ess;
    private final IMessageRecipient parent;
    private long lastMessageMs;
    private WeakReference<IMessageRecipient> replyRecipient;

    public SimpleMessageRecipient(IEssentials ess, IMessageRecipient parent) {
        this.ess = ess;
        this.parent = parent;
    }

    protected static User getUser(IMessageRecipient recipient) {
        if (recipient instanceof SimpleMessageRecipient) {
            return ((SimpleMessageRecipient)recipient).parent instanceof User ? (User)((SimpleMessageRecipient)recipient).parent : null;
        }
        return recipient instanceof User ? (User)recipient : null;
    }

    @Override
    public void sendMessage(String message) {
        this.parent.sendMessage(message);
    }

    @Override
    public String getName() {
        return this.parent.getName();
    }

    @Override
    public String getDisplayName() {
        return this.parent.getDisplayName();
    }

    @Override
    public IMessageRecipient.MessageResponse sendMessage(IMessageRecipient recipient, String message) {
        PrivateMessagePreSendEvent preSendEvent = new PrivateMessagePreSendEvent(this.parent, recipient, message);
        this.ess.getServer().getPluginManager().callEvent((Event)preSendEvent);
        if (preSendEvent.isCancelled()) {
            return IMessageRecipient.MessageResponse.EVENT_CANCELLED;
        }
        message = preSendEvent.getMessage();
        IMessageRecipient.MessageResponse messageResponse = recipient.onReceiveMessage(this.parent, message);
        switch (messageResponse) {
            case UNREACHABLE: {
                this.sendMessage(I18n.tl("recentlyForeverAlone", recipient.getDisplayName()));
                break;
            }
            case MESSAGES_IGNORED: {
                this.sendMessage(I18n.tl("msgIgnore", recipient.getDisplayName()));
                break;
            }
            case SENDER_IGNORED: {
                break;
            }
            case SUCCESS_BUT_AFK: {
                if (((IUser)((Object)recipient)).getAfkMessage() != null) {
                    this.sendMessage(I18n.tl("userAFKWithMessage", recipient.getDisplayName(), ((IUser)((Object)recipient)).getAfkMessage()));
                } else {
                    this.sendMessage(I18n.tl("userAFK", recipient.getDisplayName()));
                }
            }
            default: {
                this.sendMessage(I18n.tl("msgFormat", I18n.tl("meSender", new Object[0]), recipient.getDisplayName(), message));
                if (!this.ess.getSettings().isSocialSpyMessages()) break;
                User senderUser = SimpleMessageRecipient.getUser(this);
                User recipientUser = SimpleMessageRecipient.getUser(recipient);
                if (senderUser == null || senderUser.isAuthorized("essentials.chat.spy.exempt") || recipientUser == null || recipientUser.isAuthorized("essentials.chat.spy.exempt")) break;
                for (User onlineUser : this.ess.getOnlineUsers()) {
                    if (!onlineUser.isSocialSpyEnabled() || onlineUser.equals(senderUser) || onlineUser.equals(recipient)) continue;
                    if (senderUser.isMuted() && this.ess.getSettings().getSocialSpyListenMutedPlayers()) {
                        onlineUser.sendMessage(I18n.tl("socialMutedSpyPrefix", new Object[0]) + I18n.tl("socialSpyMsgFormat", this.getDisplayName(), recipient.getDisplayName(), message));
                        continue;
                    }
                    onlineUser.sendMessage(I18n.tl("socialSpyPrefix", new Object[0]) + I18n.tl("socialSpyMsgFormat", this.getDisplayName(), recipient.getDisplayName(), message));
                }
            }
        }
        if (messageResponse.isSuccess()) {
            this.setReplyRecipient(recipient);
        }
        PrivateMessageSentEvent sentEvent = new PrivateMessageSentEvent(this.parent, recipient, message, messageResponse);
        this.ess.getServer().getPluginManager().callEvent((Event)sentEvent);
        return messageResponse;
    }

    @Override
    public IMessageRecipient.MessageResponse onReceiveMessage(IMessageRecipient sender, String message) {
        if (!this.isReachable()) {
            return IMessageRecipient.MessageResponse.UNREACHABLE;
        }
        User user = SimpleMessageRecipient.getUser(this);
        boolean afk = false;
        boolean isLastMessageReplyRecipient = this.ess.getSettings().isLastMessageReplyRecipient();
        if (user != null) {
            if (user.isIgnoreMsg() && sender instanceof IUser && !((IUser)((Object)sender)).isAuthorized("essentials.msgtoggle.bypass")) {
                return IMessageRecipient.MessageResponse.MESSAGES_IGNORED;
            }
            afk = user.isAfk();
            isLastMessageReplyRecipient = user.isLastMessageReplyRecipient();
            if (sender instanceof IUser && user.isIgnoredPlayer((IUser)((Object)sender))) {
                return IMessageRecipient.MessageResponse.SENDER_IGNORED;
            }
        }
        this.sendMessage(I18n.tl("msgFormat", sender.getDisplayName(), I18n.tl("meRecipient", new Object[0]), message));
        if (isLastMessageReplyRecipient) {
            long timeout = this.ess.getSettings().getLastMessageReplyRecipientTimeout() * 1000L;
            if (this.getReplyRecipient() == null || !this.getReplyRecipient().isReachable() || System.currentTimeMillis() - this.lastMessageMs > timeout) {
                this.setReplyRecipient(sender);
            }
        } else {
            this.setReplyRecipient(sender);
        }
        this.lastMessageMs = System.currentTimeMillis();
        return afk ? IMessageRecipient.MessageResponse.SUCCESS_BUT_AFK : IMessageRecipient.MessageResponse.SUCCESS;
    }

    @Override
    public boolean isReachable() {
        return this.parent.isReachable();
    }

    @Override
    public IMessageRecipient getReplyRecipient() {
        return this.replyRecipient == null ? null : (IMessageRecipient)this.replyRecipient.get();
    }

    @Override
    public void setReplyRecipient(IMessageRecipient replyRecipient) {
        this.replyRecipient = new WeakReference<IMessageRecipient>(replyRecipient);
    }

    @Override
    public boolean isHiddenFrom(Player player) {
        return this.parent.isHiddenFrom(player);
    }
}

