/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.metrics;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.metrics.Metrics;
import com.earth2me.essentials.register.payment.Methods;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MetricsWrapper {
    private static final List<String> KNOWN_FORCED_METRICS = ImmutableList.of((Object)"ChatControl", (Object)"catserver.server.Metrics");
    private static boolean hasWarned = false;
    private final Essentials ess;
    private final Metrics metrics;
    private final Map<String, Boolean> commands = new HashMap<String, Boolean>();
    private final Plugin plugin;

    public MetricsWrapper(Plugin plugin, int pluginId, boolean includeCommands) {
        this.plugin = plugin;
        this.ess = (Essentials)Bukkit.getPluginManager().getPlugin("Essentials");
        this.metrics = new Metrics(plugin, pluginId);
        if (this.metrics.isEnabled()) {
            plugin.getLogger().info("Starting Metrics. Opt-out using the global bStats config.");
        } else {
            plugin.getLogger().info("Metrics disabled per bStats config.");
        }
        this.checkForcedMetrics();
        this.addPermsChart();
        this.addEconomyChart();
        this.addReleaseBranchChart();
        this.addVersionHistoryChart();
        if (includeCommands) {
            this.addCommandsChart();
        }
    }

    public void markCommand(String command, boolean state) {
        this.commands.put(command, state);
    }

    public void addCustomChart(Metrics.CustomChart chart) {
        this.metrics.addCustomChart(chart);
    }

    private void addPermsChart() {
        this.metrics.addCustomChart(new Metrics.DrilldownPie("permsPlugin", () -> {
            HashMap result = new HashMap();
            String handler = this.ess.getPermissionsHandler().getName();
            HashMap<String, Integer> backend = new HashMap<String, Integer>();
            backend.put(this.ess.getPermissionsHandler().getBackendName(), 1);
            result.put(handler, backend);
            return result;
        }));
    }

    private void addEconomyChart() {
        this.metrics.addCustomChart(new Metrics.DrilldownPie("econPlugin", () -> {
            HashMap result = new HashMap();
            HashMap<String, Integer> backend = new HashMap<String, Integer>();
            if (Methods.hasMethod()) {
                backend.put(Methods.getMethod().getBackend(), 1);
                result.put(Methods.getMethod().getName(), backend);
            } else {
                backend.put("Essentials", 1);
                result.put("Essentials", backend);
            }
            return result;
        }));
    }

    private void addVersionHistoryChart() {
        this.metrics.addCustomChart(new Metrics.MultiLineChart("versionHistory", () -> {
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            result.put(this.plugin.getDescription().getVersion(), 1);
            return result;
        }));
    }

    private void addReleaseBranchChart() {
        this.metrics.addCustomChart(new Metrics.SimplePie("releaseBranch", this.ess.getUpdateChecker()::getVersionBranch));
    }

    private void addCommandsChart() {
        for (String command : this.plugin.getDescription().getCommands().keySet()) {
            this.markCommand(command, false);
        }
        this.metrics.addCustomChart(new Metrics.AdvancedBarChart("commands", () -> {
            HashMap<String, int[]> result = new HashMap<String, int[]>();
            for (Map.Entry<String, Boolean> entry : this.commands.entrySet()) {
                if (entry.getValue().booleanValue()) {
                    result.put(entry.getKey(), new int[]{1, 0});
                    continue;
                }
                result.put(entry.getKey(), new int[]{0, 1});
            }
            return result;
        }));
    }

    private boolean isForcedMetricsClass(Class<?> bStatsService) {
        for (String identifier : KNOWN_FORCED_METRICS) {
            if (!bStatsService.getCanonicalName().contains(identifier)) continue;
            return true;
        }
        JavaPlugin owningPlugin = this.getProvidingPlugin(bStatsService);
        return owningPlugin != null && KNOWN_FORCED_METRICS.contains(owningPlugin.getName());
    }

    private void checkForcedMetrics() {
        if (hasWarned) {
            return;
        }
        hasWarned = true;
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(this.plugin, () -> {
            for (Class service : Bukkit.getServicesManager().getKnownServices()) {
                try {
                    service.getField("B_STATS_VERSION");
                    if (this.isForcedMetricsClass(service)) {
                        this.warnForcedMetrics(service);
                        continue;
                    }
                    try {
                        service.getDeclaredField("pluginId");
                    }
                    catch (NoSuchFieldException e) {
                        break;
                    }
                    try {
                        service.getDeclaredField("enabled");
                    }
                    catch (NoSuchFieldException e) {
                        this.warnForcedMetrics(service);
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {}
            }
        });
    }

    private void warnForcedMetrics(Class<?> service) {
        JavaPlugin servicePlugin = JavaPlugin.getProvidingPlugin(service);
        this.plugin.getLogger().severe("WARNING: Potential forced metrics collection by plugin '" + servicePlugin.getName() + "' v" + servicePlugin.getDescription().getVersion());
        this.plugin.getLogger().severe("Your server is running a plugin that may not respect bStats' opt-out settings.");
        this.plugin.getLogger().severe("This may cause data to be uploaded to bStats.org for plugins that use bStats, even if you've opted out in the bStats config.");
        this.plugin.getLogger().severe("Please report this to bStats and to the authors of '" + servicePlugin.getName() + "'. (Offending class: " + service.getName() + ")");
    }

    private JavaPlugin getProvidingPlugin(Class<?> clazz) {
        try {
            return JavaPlugin.getProvidingPlugin(clazz);
        }
        catch (Exception exception) {
            ClassLoader parent = clazz.getClassLoader().getParent();
            if (parent.getClass().getName().equals("org.bukkit.plugin.java.PluginClassLoader")) {
                try {
                    Field pluginField = parent.getClass().getDeclaredField("plugin");
                    pluginField.setAccessible(true);
                    return (JavaPlugin)pluginField.get(parent);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

