/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.perm;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.perm.IPermissionsHandler;
import com.earth2me.essentials.perm.impl.AbstractVaultHandler;
import com.earth2me.essentials.perm.impl.ConfigPermissionsHandler;
import com.earth2me.essentials.perm.impl.GenericVaultHandler;
import com.earth2me.essentials.perm.impl.LuckPermsHandler;
import com.earth2me.essentials.perm.impl.ModernVaultHandler;
import com.earth2me.essentials.perm.impl.SuperpermsHandler;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.bukkit.entity.Player;

public class PermissionsHandler
implements IPermissionsHandler {
    private final transient String defaultGroup = "default";
    private final transient Essentials ess;
    private transient IPermissionsHandler handler = null;
    private transient boolean useSuperperms;
    private Class<?> lastHandler = null;

    public PermissionsHandler(Essentials plugin, boolean useSuperperms) {
        this.ess = plugin;
        this.useSuperperms = useSuperperms;
    }

    @Override
    public String getGroup(Player base) {
        long start = System.nanoTime();
        String group = this.handler.getGroup(base);
        if (group == null) {
            group = "default";
        }
        this.checkPermLag(start, String.format("Getting group for %s", base.getName()));
        return group;
    }

    @Override
    public List<String> getGroups(Player base) {
        long start = System.nanoTime();
        List<String> groups = this.handler.getGroups(base);
        if (groups == null || groups.isEmpty()) {
            groups = Collections.singletonList("default");
        }
        this.checkPermLag(start, String.format("Getting groups for %s", base.getName()));
        return Collections.unmodifiableList(groups);
    }

    @Override
    public boolean canBuild(Player base, String group) {
        return this.handler.canBuild(base, group);
    }

    @Override
    public boolean inGroup(Player base, String group) {
        long start = System.nanoTime();
        boolean result = this.handler.inGroup(base, group);
        this.checkPermLag(start, String.format("Checking if %s is in group %s", base.getName(), group));
        return result;
    }

    @Override
    public boolean hasPermission(Player base, String node) {
        return this.handler.hasPermission(base, node);
    }

    @Override
    public boolean isPermissionSet(Player base, String node) {
        return this.handler.isPermissionSet(base, node);
    }

    @Override
    public String getPrefix(Player base) {
        long start = System.nanoTime();
        String prefix = this.handler.getPrefix(base);
        if (prefix == null) {
            prefix = "";
        }
        this.checkPermLag(start, String.format("Getting prefix for %s", base.getName()));
        return prefix;
    }

    @Override
    public String getSuffix(Player base) {
        long start = System.nanoTime();
        String suffix = this.handler.getSuffix(base);
        if (suffix == null) {
            suffix = "";
        }
        this.checkPermLag(start, String.format("Getting suffix for %s", base.getName()));
        return suffix;
    }

    @Override
    public void registerContext(String context, Function<Player, Iterable<String>> calculator, Supplier<Iterable<String>> suggestions) {
        this.handler.registerContext(context, calculator, suggestions);
    }

    @Override
    public void unregisterContexts() {
        this.handler.unregisterContexts();
    }

    @Override
    public String getBackendName() {
        return this.handler.getBackendName();
    }

    @Override
    public boolean tryProvider() {
        return true;
    }

    public void checkPermissions() {
        List<Class> providerClazz = Arrays.asList(LuckPermsHandler.class, ModernVaultHandler.class, GenericVaultHandler.class, SuperpermsHandler.class);
        for (Class providerClass : providerClazz) {
            try {
                IPermissionsHandler provider = (IPermissionsHandler)providerClass.newInstance();
                if (!provider.tryProvider()) continue;
                if (provider.getClass().isInstance(this.handler)) {
                    return;
                }
                if (this.handler != null) {
                    this.unregisterContexts();
                }
                this.handler = provider;
                this.initContexts();
                break;
            }
            catch (Throwable throwable) {
            }
        }
        if (this.handler == null) {
            this.handler = this.useSuperperms ? new SuperpermsHandler() : new ConfigPermissionsHandler(this.ess);
        }
        Class<?> handlerClass = this.handler.getClass();
        if (this.lastHandler != null && this.lastHandler == handlerClass) {
            return;
        }
        this.lastHandler = handlerClass;
        if (this.handler instanceof AbstractVaultHandler) {
            String enabledPermsPlugin = ((AbstractVaultHandler)this.handler).getEnabledPermsPlugin();
            if (enabledPermsPlugin == null) {
                enabledPermsPlugin = "generic";
            }
            this.ess.getLogger().info("Using Vault based permissions (" + enabledPermsPlugin + ")");
        } else if (this.handler.getClass() == SuperpermsHandler.class) {
            if (this.handler.tryProvider()) {
                this.ess.getLogger().warning("Detected supported permissions plugin " + ((SuperpermsHandler)this.handler).getEnabledPermsPlugin() + " without Vault installed.");
                this.ess.getLogger().warning("Features such as chat prefixes/suffixes and group-related functionality will not work until you install Vault.");
            }
            this.ess.getLogger().info("Using superperms-based permissions.");
        } else if (this.handler.getClass() == ConfigPermissionsHandler.class) {
            this.ess.getLogger().info("Using config file enhanced permissions.");
            this.ess.getLogger().info("Permissions listed in as player-commands will be given to all users.");
        }
    }

    public void setUseSuperperms(boolean useSuperperms) {
        this.useSuperperms = useSuperperms;
    }

    public String getName() {
        return this.handler.getClass().getSimpleName().replace("Provider", "");
    }

    private void checkPermLag(long start, String summary) {
        long elapsed = System.nanoTime() - start;
        if (elapsed > this.ess.getSettings().getPermissionsLagWarning()) {
            this.ess.getLogger().log(Level.WARNING, String.format("Permissions lag notice with (%s). Response took %fms. Summary: %s", this.getName(), (double)elapsed / 1000000.0, summary));
        }
    }

    private void initContexts() {
        this.registerContext("essentials:afk", player -> Collections.singleton(String.valueOf(this.ess.getUser((Player)player).isAfk())), () -> ImmutableSet.of((Object)"true", (Object)"false"));
        this.registerContext("essentials:muted", player -> Collections.singleton(String.valueOf(this.ess.getUser((Player)player).isMuted())), () -> ImmutableSet.of((Object)"true", (Object)"false"));
        this.registerContext("essentials:vanished", player -> Collections.singleton(String.valueOf(this.ess.getUser((Player)player).isHidden())), () -> ImmutableSet.of((Object)"true", (Object)"false"));
        this.registerContext("essentials:jailed", player -> Collections.singleton(String.valueOf(this.ess.getUser((Player)player).isJailed())), () -> ImmutableSet.of((Object)"true", (Object)"false"));
        this.registerContext("essentials:jail", player -> Optional.ofNullable(this.ess.getUser((Player)player).getJail()).map(xva$0 -> Arrays.asList(xva$0)).orElse(Collections.emptyList()), () -> {
            try {
                return this.ess.getJails().getList();
            }
            catch (Exception e) {
                return Collections.emptyList();
            }
        });
    }
}

