/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.perm.impl;

import com.earth2me.essentials.perm.impl.ModernVaultHandler;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.context.ContextCalculator;
import net.luckperms.api.context.ContextConsumer;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class LuckPermsHandler
extends ModernVaultHandler {
    private LuckPerms luckPerms;
    private Set<ContextCalculator<Player>> contextCalculators;

    @Override
    public void registerContext(final String context, final Function<Player, Iterable<String>> calculator, final Supplier<Iterable<String>> suggestions) {
        ContextCalculator<Player> contextCalculator = new ContextCalculator<Player>(){

            public void calculate(Player target, ContextConsumer consumer) {
                ((Iterable)calculator.apply(target)).forEach(value -> consumer.accept(context, value));
            }

            public ContextSet estimatePotentialContexts() {
                ImmutableContextSet.Builder builder = ImmutableContextSet.builder();
                ((Iterable)suggestions.get()).forEach(value -> builder.add(context, value));
                return builder.build();
            }
        };
        this.luckPerms.getContextManager().registerCalculator((ContextCalculator)contextCalculator);
        this.contextCalculators.add(contextCalculator);
    }

    @Override
    public void unregisterContexts() {
        this.contextCalculators.forEach(contextCalculator -> this.luckPerms.getContextManager().unregisterCalculator(contextCalculator));
        this.contextCalculators.clear();
    }

    @Override
    public boolean tryProvider() {
        RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(LuckPerms.class);
        if (provider != null) {
            this.luckPerms = (LuckPerms)provider.getProvider();
            this.contextCalculators = new HashSet<ContextCalculator<Player>>();
        }
        return this.luckPerms != null && super.tryProvider();
    }
}

