/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.signs;

import com.earth2me.essentials.ChargeException;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.signs.EssentialsSign;
import com.earth2me.essentials.signs.SignException;
import net.ess3.api.IEssentials;

public class SignTime
extends EssentialsSign {
    public SignTime() {
        super("Time");
    }

    @Override
    protected boolean onSignCreate(EssentialsSign.ISign sign, User player, String username, IEssentials ess) throws SignException {
        this.validateTrade(sign, 2, ess);
        String timeString = sign.getLine(1);
        if ("Day".equalsIgnoreCase(timeString)) {
            sign.setLine(1, "\u00a72Day");
            return true;
        }
        if ("Night".equalsIgnoreCase(timeString)) {
            sign.setLine(1, "\u00a72Night");
            return true;
        }
        throw new SignException(I18n.tl("onlyDayNight", new Object[0]));
    }

    @Override
    protected boolean onSignInteract(EssentialsSign.ISign sign, User player, String username, IEssentials ess) throws SignException, ChargeException {
        Trade charge = this.getTrade(sign, 2, ess);
        charge.isAffordableFor(player);
        String timeString = sign.getLine(1);
        long time = player.getWorld().getTime();
        time -= time % 24000L;
        if ("\u00a72Day".equalsIgnoreCase(timeString)) {
            player.getWorld().setTime(time + 24000L);
            charge.charge(player);
            Trade.log("Sign", "TimeDay", "Interact", username, null, username, charge, sign.getBlock().getLocation(), player.getMoney(), ess);
            return true;
        }
        if ("\u00a72Night".equalsIgnoreCase(timeString)) {
            player.getWorld().setTime(time + 37700L);
            charge.charge(player);
            Trade.log("Sign", "TimeNight", "Interact", username, null, username, charge, sign.getBlock().getLocation(), player.getMoney(), ess);
            return true;
        }
        throw new SignException(I18n.tl("onlyDayNight", new Object[0]));
    }
}

