/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.storage;

import com.earth2me.essentials.Enchantments;
import com.earth2me.essentials.storage.EnchantmentLevel;
import com.earth2me.essentials.utils.NumberUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;

public class BukkitConstructor
extends CustomClassLoaderConstructor {
    private Method constructScalarMethod = null;

    public BukkitConstructor(Class<?> clazz, Plugin plugin) {
        super(clazz, plugin.getClass().getClassLoader());
        this.yamlClassConstructors.put(NodeId.scalar, new ConstructBukkitScalar());
        this.yamlClassConstructors.put(NodeId.mapping, new ConstructBukkitMapping());
        PropertyUtils propertyUtils = this.getPropertyUtils();
        propertyUtils.setSkipMissingProperties(true);
        this.setPropertyUtils(propertyUtils);
    }

    protected String constructScalarRefl(ScalarNode scalarNode) {
        try {
            if (this.constructScalarMethod == null) {
                this.constructScalarMethod = BaseConstructor.class.getDeclaredMethod("constructScalar", ScalarNode.class);
            }
            return (String)this.constructScalarMethod.invoke((Object)this, scalarNode);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private class ConstructBukkitMapping
    extends Constructor.ConstructMapping {
        private ConstructBukkitMapping() {
            super((Constructor)BukkitConstructor.this);
        }

        public Object construct(Node node) {
            if (node.getType().equals(Location.class)) {
                MappingNode mnode = (MappingNode)node;
                String worldName = "";
                double x = 0.0;
                double y = 0.0;
                double z = 0.0;
                float yaw = 0.0f;
                float pitch = 0.0f;
                if (mnode.getValue().size() < 4) {
                    return null;
                }
                for (NodeTuple nodeTuple : mnode.getValue()) {
                    String key = BukkitConstructor.this.constructScalarRefl((ScalarNode)nodeTuple.getKeyNode());
                    ScalarNode snode = (ScalarNode)nodeTuple.getValueNode();
                    if (key.equalsIgnoreCase("world")) {
                        worldName = BukkitConstructor.this.constructScalarRefl(snode);
                    }
                    if (key.equalsIgnoreCase("x")) {
                        x = Double.parseDouble(BukkitConstructor.this.constructScalarRefl(snode));
                    }
                    if (key.equalsIgnoreCase("y")) {
                        y = Double.parseDouble(BukkitConstructor.this.constructScalarRefl(snode));
                    }
                    if (key.equalsIgnoreCase("z")) {
                        z = Double.parseDouble(BukkitConstructor.this.constructScalarRefl(snode));
                    }
                    if (key.equalsIgnoreCase("yaw")) {
                        yaw = Float.parseFloat(BukkitConstructor.this.constructScalarRefl(snode));
                    }
                    if (!key.equalsIgnoreCase("pitch")) continue;
                    pitch = Float.parseFloat(BukkitConstructor.this.constructScalarRefl(snode));
                }
                if (worldName == null || worldName.isEmpty()) {
                    return null;
                }
                World world = Bukkit.getWorld((String)worldName);
                if (world == null) {
                    return null;
                }
                return new Location(world, x, y, z, yaw, pitch);
            }
            return super.construct(node);
        }
    }

    private class ConstructBukkitScalar
    extends Constructor.ConstructScalar {
        private ConstructBukkitScalar() {
            super((Constructor)BukkitConstructor.this);
        }

        public Object construct(Node node) {
            if (node.getType().equals(Material.class)) {
                String val = BukkitConstructor.this.constructScalarRefl((ScalarNode)node);
                return Material.matchMaterial((String)val);
            }
            if (node.getType().equals(MaterialData.class)) {
                String val = BukkitConstructor.this.constructScalarRefl((ScalarNode)node);
                if (val.isEmpty()) {
                    return null;
                }
                String[] split = val.split("[:+',;.]", 2);
                if (split.length == 0) {
                    return null;
                }
                Material mat = Material.matchMaterial((String)split[0]);
                if (mat == null) {
                    return null;
                }
                byte data = 0;
                if (split.length == 2 && NumberUtil.isInt(split[1])) {
                    data = Byte.parseByte(split[1]);
                }
                return new MaterialData(mat, data);
            }
            if (node.getType().equals(ItemStack.class)) {
                String val = BukkitConstructor.this.constructScalarRefl((ScalarNode)node);
                if (val.isEmpty()) {
                    return null;
                }
                String[] split1 = val.split("\\W");
                if (split1.length == 0) {
                    return null;
                }
                String[] split2 = split1[0].split("[:+',;.]", 2);
                if (split2.length == 0) {
                    return null;
                }
                Material mat = Material.matchMaterial((String)split2[0]);
                if (mat == null) {
                    return null;
                }
                short data = 0;
                if (split2.length == 2 && NumberUtil.isInt(split2[1])) {
                    data = Short.parseShort(split2[1]);
                }
                int size = mat.getMaxStackSize();
                if (split1.length > 1 && NumberUtil.isInt(split1[1])) {
                    size = Integer.parseInt(split1[1]);
                }
                ItemStack stack = new ItemStack(mat, size, data);
                if (split1.length > 2) {
                    for (int i = 2; i < split1.length; ++i) {
                        Enchantment enchantment;
                        String[] split3 = split1[0].split("[:+',;.]", 2);
                        if (split3.length < 1 || (enchantment = Enchantments.getByName(split3[0])) == null) continue;
                        int level = enchantment.getStartLevel();
                        if (split3.length == 2 && NumberUtil.isInt(split3[1])) {
                            level = Integer.parseInt(split3[1]);
                        }
                        if (level < enchantment.getStartLevel()) {
                            level = enchantment.getStartLevel();
                        }
                        if (level > enchantment.getMaxLevel()) {
                            level = enchantment.getMaxLevel();
                        }
                        stack.addUnsafeEnchantment(enchantment, level);
                    }
                }
                return stack;
            }
            if (node.getType().equals(EnchantmentLevel.class)) {
                String val = BukkitConstructor.this.constructScalarRefl((ScalarNode)node);
                if (val.isEmpty()) {
                    return null;
                }
                String[] split = val.split("[:+',;.]", 2);
                if (split.length == 0) {
                    return null;
                }
                Enchantment enchant = Enchantments.getByName(split[0]);
                if (enchant == null) {
                    return null;
                }
                int level = enchant.getStartLevel();
                if (split.length == 2 && NumberUtil.isInt(split[1])) {
                    level = Integer.parseInt(split[1]);
                }
                if (level < enchant.getStartLevel()) {
                    level = enchant.getStartLevel();
                }
                if (level > enchant.getMaxLevel()) {
                    level = enchant.getMaxLevel();
                }
                return new EnchantmentLevel(enchant, level);
            }
            return super.construct(node);
        }
    }
}

