/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.loot;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.conditions.SurvivesExplosion;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import shadows.placebo.Placebo;
import shadows.placebo.loot.PoolBuilder;
import shadows.placebo.loot.StackLootEntry;

public class LootSystem {
    private static final Map<ResourceLocation, LootTable> PLACEBO_TABLES = new HashMap<ResourceLocation, LootTable>();

    public static void registerLootTable(ResourceLocation key, LootTable table) {
        if (!PLACEBO_TABLES.containsKey(key)) {
            PLACEBO_TABLES.put(key, table);
        } else {
            Placebo.LOGGER.warn("Duplicate loot entry detected, this is not allowed!  Key: " + key);
        }
    }

    public static LootTable.Builder tableBuilder() {
        return new LootTable.Builder();
    }

    public static PoolBuilder poolBuilder(int minRolls, int maxRolls) {
        return new PoolBuilder(minRolls, maxRolls);
    }

    public static void defaultBlockTable(Block b) {
        LootTable.Builder builder = LootSystem.tableBuilder();
        builder.func_216040_a(LootSystem.poolBuilder(1, 1).addEntries(new LootEntry[]{new StackLootEntry(new ItemStack((IItemProvider)b))}).func_212840_b_(SurvivesExplosion.func_215968_b()));
        LootSystem.registerLootTable(new ResourceLocation(b.getRegistryName().func_110624_b(), "blocks/" + b.getRegistryName().func_110623_a()), builder.func_216038_b());
    }

    public static void reload(LootTableManager mgr) {
        mgr.field_186527_c = new HashMap(mgr.field_186527_c);
        PLACEBO_TABLES.forEach((key, val) -> {
            if (!mgr.field_186527_c.containsKey(key)) {
                mgr.field_186527_c.put(key, val);
            }
        });
        Placebo.LOGGER.info("Registered {} additional loot tables.", (Object)PLACEBO_TABLES.keySet().size());
    }
}

