/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.brazier;

import com.mojang.datafixers.util.Pair;
import com.possible_triangle.brazier.Brazier;
import com.possible_triangle.brazier.config.ServerConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import me.shedaniel.architectury.registry.RegistrySupplier;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class Conditional {
    private static final List<Conditional> CONDITIONALS = new ArrayList<Conditional>();
    public final Predicate<ServerConfig> condition;
    public final List<RegistrySupplier<? extends IItemProvider>> items = new ArrayList<RegistrySupplier<? extends IItemProvider>>();
    public final List<Pair<ResourceLocation, ResourceLocation>> loot = new ArrayList<Pair<ResourceLocation, ResourceLocation>>();

    @SafeVarargs
    public static Conditional when(Predicate<ServerConfig> condition, RegistrySupplier<? extends IItemProvider> ... items) {
        Conditional conditional = new Conditional(condition);
        CONDITIONALS.add(conditional);
        if (items.length > 0) {
            conditional.add(items);
        }
        return conditional;
    }

    public static Stream<IItemProvider> disabled() {
        ServerConfig config = Brazier.SERVER_CONFIG.get();
        return CONDITIONALS.stream().filter(e -> !e.condition.test(config)).map(c -> c.items).flatMap(Collection::stream).filter(RegistrySupplier::isPresent).map(Supplier::get);
    }

    public static void injectLoot(ResourceLocation target, Consumer<LootPool.Builder> table) {
        ServerConfig config = Brazier.SERVER_CONFIG.get();
        CONDITIONALS.stream().filter(e -> e.condition.test(config)).map(conditional -> conditional.loot).flatMap(Collection::stream).filter(p -> ((ResourceLocation)p.getFirst()).equals((Object)target)).map(p -> LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)((ResourceLocation)p.getSecond())))).forEach(table);
    }

    public static void removeTags(ITagCollectionSupplier tags) {
    }

    private Conditional(Predicate<ServerConfig> condition) {
        this.condition = condition;
    }

    @SafeVarargs
    final Conditional add(RegistrySupplier<? extends IItemProvider> ... item) {
        this.items.addAll(Arrays.asList(item));
        return this;
    }

    final Conditional loot(ResourceLocation target, ResourceLocation inject) {
        this.loot.add((Pair<ResourceLocation, ResourceLocation>)new Pair((Object)target, (Object)inject));
        return this;
    }

    final Conditional loot(ResourceLocation target, String inject) {
        return this.loot(target, new ResourceLocation("brazier", "inject/" + inject));
    }
}

