/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.brazier;

import com.possible_triangle.brazier.Conditional;
import com.possible_triangle.brazier.block.BrazierBlock;
import com.possible_triangle.brazier.block.LazyTorchBlock;
import com.possible_triangle.brazier.block.LazyWallTorchBlock;
import com.possible_triangle.brazier.block.SpawnPowder;
import com.possible_triangle.brazier.block.tile.BrazierTile;
import com.possible_triangle.brazier.block.tile.render.BrazierRenderer;
import com.possible_triangle.brazier.entity.Crazed;
import com.possible_triangle.brazier.entity.CrazedFlame;
import com.possible_triangle.brazier.entity.EntityUtil;
import com.possible_triangle.brazier.entity.render.CrazedFlameRenderer;
import com.possible_triangle.brazier.entity.render.CrazedRender;
import com.possible_triangle.brazier.item.HiddenItem;
import com.possible_triangle.brazier.item.LazySpawnEgg;
import com.possible_triangle.brazier.item.LivingTorch;
import com.possible_triangle.brazier.particle.FlameParticle;
import com.possible_triangle.brazier.particle.ModdedParticleType;
import com.possible_triangle.brazier.particle.ParticleRegistry;
import java.awt.Color;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import me.shedaniel.architectury.hooks.TagHooks;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.architectury.registry.BlockEntityRenderers;
import me.shedaniel.architectury.registry.DeferredRegister;
import me.shedaniel.architectury.registry.RegistrySupplier;
import me.shedaniel.architectury.registry.RenderTypes;
import me.shedaniel.architectury.registry.entity.EntityRenderers;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.LanternBlock;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Rarity;
import net.minecraft.loot.LootTables;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Content {
    public static final ITag.INamedTag<Block> BRAZIER_BASE_BLOCKS = TagHooks.getBlockOptional((ResourceLocation)new ResourceLocation("brazier", "brazier_base_blocks"));
    public static final ITag.INamedTag<EntityType<?>> BRAZIER_WHITELIST = TagHooks.getEntityTypeOptional((ResourceLocation)new ResourceLocation("brazier", "brazier_whitelist"));
    public static final ITag.INamedTag<EntityType<?>> BRAZIER_BLACKLIST = TagHooks.getEntityTypeOptional((ResourceLocation)new ResourceLocation("brazier", "brazier_blacklist"));
    public static final ITag.INamedTag<Item> TORCHES = TagHooks.getItemOptional((ResourceLocation)new ResourceLocation("brazier", "torches"));
    public static final ITag.INamedTag<Item> ASH_TAG = TagHooks.getItemOptional((ResourceLocation)new ResourceLocation("brazier", "ash"));
    public static final ITag.INamedTag<Item> IRON_NUGGET_TAG = TagHooks.getItemOptional((ResourceLocation)new ResourceLocation("brazier", "iron_nuggets"));
    public static final ITag.INamedTag<Item> WARPED_WART_TAG = TagHooks.getItemOptional((ResourceLocation)new ResourceLocation("brazier", "warped_wart"));
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"brazier", (RegistryKey)Registry.field_239714_o_);
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"brazier", (RegistryKey)Registry.field_239711_l_);
    public static final DeferredRegister<TileEntityType<?>> TILES = DeferredRegister.create((String)"brazier", (RegistryKey)Registry.field_239667_E_);
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((String)"brazier", (RegistryKey)Registry.field_239713_n_);
    public static final DeferredRegister<ParticleType<?>> PARTICLES = DeferredRegister.create((String)"brazier", (RegistryKey)Registry.field_239664_B_);
    public static final RegistrySupplier<BasicParticleType> FLAME_PARTICLE = PARTICLES.register("flame", () -> new ModdedParticleType(false));
    public static final RegistrySupplier<BrazierBlock> BRAZIER = Content.registerBlock("brazier", BrazierBlock::new, p -> p.func_200916_a(ItemGroup.field_78026_f));
    public static final RegistrySupplier<TileEntityType<BrazierTile>> BRAZIER_TILE = TILES.register("brazier", () -> TileEntityType.Builder.func_223042_a(BrazierTile::new, (Block[])new Block[]{(Block)BRAZIER.get()}).func_206865_a(null));
    public static final RegistrySupplier<LazyTorchBlock> LIVING_TORCH_BLOCK = BLOCKS.register("living_torch", () -> new LazyTorchBlock((Supplier<? extends IParticleData>)FLAME_PARTICLE));
    public static final RegistrySupplier<LazyWallTorchBlock> LIVING_TORCH_BLOCK_WALL = BLOCKS.register("living_wall_torch", () -> new LazyWallTorchBlock((Supplier<? extends IParticleData>)FLAME_PARTICLE));
    public static final RegistrySupplier<Block> LIVING_LANTERN = Content.registerBlock("living_lantern", () -> new LanternBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_222432_lU)), p -> p.func_200916_a(ItemGroup.field_78031_c));
    public static final RegistrySupplier<Item> LIVING_FLAME = ITEMS.register("living_flame", () -> new Item(new Item.Properties().func_200916_a(ItemGroup.field_78038_k).func_208103_a(Rarity.UNCOMMON)));
    public static final RegistrySupplier<LivingTorch> LIVING_TORCH = ITEMS.register("living_torch", LivingTorch::new);
    public static final RegistrySupplier<Item> ASH = ITEMS.register("ash", () -> new Item(new Item.Properties().func_200916_a(ItemGroup.field_78035_l)));
    public static final RegistrySupplier<Item> WARPED_NETHERWART = ITEMS.register("warped_nether_wart", () -> new Item(new Item.Properties().func_200916_a(ItemGroup.field_78035_l)));
    public static final RegistrySupplier<Block> SPAWN_POWDER = Content.registerBlock("spawn_powder", SpawnPowder::new, p -> p.func_200916_a(ItemGroup.field_78035_l));
    public static final RegistrySupplier<EntityType<Crazed>> CRAZED = ENTITIES.register("crazed", () -> EntityUtil.buildType(EntityClassification.MONSTER, Crazed::new).size(2.0f, 0.5f).fireImmune().build("crazed"));
    public static final RegistrySupplier<LazySpawnEgg> CRAZED_SPAWN_EGG = ITEMS.register("crazed_spawn_egg", () -> new LazySpawnEgg(CRAZED, new Color(0x959B9B).getRGB(), new Color(9030407).getRGB()));
    public static final RegistrySupplier<EntityType<CrazedFlame>> CRAZED_FLAME = ENTITIES.register("crazed_flame", () -> EntityUtil.buildType(EntityClassification.MISC, CrazedFlame::new).size(0.6f, 0.6f).fireImmune().clientHandler(CrazedFlame::new).build("crazed_flame"));
    public static final RegistrySupplier<HiddenItem> ICON = ITEMS.register("icon", HiddenItem::new);

    public static <T extends Block> RegistrySupplier<T> registerBlock(String name, Supplier<T> supplier, Function<Item.Properties, Item.Properties> props) {
        RegistrySupplier block = BLOCKS.register(name, supplier);
        ITEMS.register(name, () -> new BlockItem((Block)block.get(), (Item.Properties)props.apply(new Item.Properties())));
        return block;
    }

    public static void init() {
        PARTICLES.register();
        ENTITIES.register();
        BLOCKS.register();
        ITEMS.register();
        TILES.register();
    }

    public static void setup() {
        CRAZED.ifPresent(Crazed::init);
        Conditional.when(config -> config.DECORATION, LIVING_LANTERN, LIVING_TORCH);
        Conditional.when(config -> config.SPAWN_POWDER, SPAWN_POWDER);
        Conditional.when(config -> config.JUNGLE_LOOT, new RegistrySupplier[0]).loot(LootTables.field_186430_l, "flame_jungle_temple");
        Conditional.when($ -> !Platform.isModLoaded((String)"nether_extension"), new RegistrySupplier[0]).add(ASH, WARPED_NETHERWART).loot(EntityType.field_200722_aA.func_220348_g(), "wither_ash").loot(Blocks.field_150388_bm.func_220068_i(), "warped_wart");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerParticles() {
        FLAME_PARTICLE.ifPresent(type -> ParticleRegistry.registerFactory(type, FlameParticle::new));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientSetup() {
        CRAZED.ifPresent(type -> EntityRenderers.register((EntityType)type, CrazedRender::new));
        CRAZED_FLAME.ifPresent(type -> EntityRenderers.register((EntityType)type, CrazedFlameRenderer::new));
        Stream.of(BRAZIER, LIVING_TORCH_BLOCK, LIVING_TORCH_BLOCK_WALL, SPAWN_POWDER, LIVING_LANTERN).filter(RegistrySupplier::isPresent).map(Supplier::get).map(b -> b).forEach(block -> RenderTypes.register((RenderType)RenderType.func_228643_e_(), (Block[])new Block[]{block}));
        BRAZIER_TILE.ifPresent(tile -> BlockEntityRenderers.registerRenderer((TileEntityType)tile, BrazierRenderer::new));
    }
}

