/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.brazier.block.tile;

import com.google.common.collect.Maps;
import com.possible_triangle.brazier.Brazier;
import com.possible_triangle.brazier.Content;
import com.possible_triangle.brazier.block.BrazierBlock;
import com.possible_triangle.brazier.block.tile.BaseTile;
import com.possible_triangle.brazier.config.DistanceHandler;
import com.possible_triangle.brazier.config.ServerConfig;
import java.util.HashMap;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;

public class BrazierTile
extends BaseTile
implements ITickableTileEntity {
    private static final HashMap<BlockPos, Integer> BRAZIERS = Maps.newHashMap();
    private static final float TOLERANCE = 0.03f;
    private int ticksExisted = 0;
    private int height = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBorder(Vector3d pos) {
        HashMap<BlockPos, Integer> hashMap = BRAZIERS;
        synchronized (hashMap) {
            return BRAZIERS.entrySet().stream().anyMatch(e -> {
                double dist = DistanceHandler.getDistance(pos, (BlockPos)e.getKey());
                double minDist = Math.pow((float)((Integer)e.getValue()).intValue() - 0.03f, 2.0);
                double maxDist = Math.pow((float)((Integer)e.getValue()).intValue() + 0.03f, 2.0);
                return dist <= maxDist && dist >= minDist;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean inRange(BlockPos pos) {
        HashMap<BlockPos, Integer> hashMap = BRAZIERS;
        synchronized (hashMap) {
            return BRAZIERS.entrySet().stream().anyMatch(e -> {
                int maxDist;
                if (!Brazier.SERVER_CONFIG.get().PROTECT_ABOVE && ((BlockPos)e.getKey()).func_177956_o() < pos.func_177956_o()) {
                    return false;
                }
                double dist = DistanceHandler.getDistance(pos, (BlockPos)e.getKey());
                return dist <= (double)(maxDist = (Integer)e.getValue() * (Integer)e.getValue());
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHeight(int height) {
        if (this.height != height) {
            this.height = height;
            this.func_70296_d();
            if (this.func_174877_v() != null) {
                HashMap<BlockPos, Integer> hashMap = BRAZIERS;
                synchronized (hashMap) {
                    BRAZIERS.put(this.func_174877_v(), this.getRange());
                }
            }
        }
    }

    public void func_73660_a() {
        ++this.ticksExisted;
        if (this.ticksExisted % 40 == 0) {
            this.checkStructure();
        }
        if (this.height > 0 && this.field_145850_b instanceof ServerWorld && this.ticksExisted % 10 == 0) {
            BlockPos pos = this.func_174877_v();
            ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)((BasicParticleType)Content.FLAME_PARTICLE.get()), (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 2), (double)pos.func_177952_p() + 0.5, 1, 0.4, 0.8, 0.4, 0.0);
        }
    }

    public void playSound(SoundEvent sound) {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    private void checkStructure() {
        int height;
        if (this.field_145850_b != null && (height = this.findHeight()) != this.height) {
            this.setHeight(height);
            BlockState s = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)s.func_206870_a((Property)BrazierBlock.LIT, (Comparable)Boolean.valueOf(height > 0)));
            if (height > 0) {
                this.playSound(SoundEvents.field_187616_bj);
            } else {
                this.playSound(SoundEvents.field_187646_bt);
            }
        }
    }

    private int findHeight() {
        assert (this.field_145850_b != null);
        int max = Brazier.SERVER_CONFIG.get().MAX_HEIGHT;
        BlockPos pos = this.func_174877_v();
        if (!this.field_145850_b.func_180495_p(pos.func_177984_a()).func_196958_f()) {
            return 0;
        }
        for (int height = 1; height <= max; ++height) {
            boolean b = true;
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    if (Math.abs(x * z) >= 4) continue;
                    BlockState state = this.field_145850_b.func_180495_p(pos.func_177982_a(x, -height, z));
                    b = b && state.func_235714_a_(Content.BRAZIER_BASE_BLOCKS);
                }
            }
            if (b) continue;
            return height - 1;
        }
        return max;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        if (nbt.func_74764_b("height")) {
            this.setHeight(nbt.func_74762_e("height"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_74768_a("height", this.height);
        return nbt;
    }

    public BrazierTile() {
        super((TileEntityType)Content.BRAZIER_TILE.get());
    }

    public int getRange() {
        if (this.height <= 0) {
            return 0;
        }
        ServerConfig config = Brazier.SERVER_CONFIG.get();
        return config.BASE_RANGE + config.RANGE_PER_LEVEL * (this.height - 1);
    }

    public int getHeight() {
        return this.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLoad() {
        if (this.height > 0) {
            HashMap<BlockPos, Integer> hashMap = BRAZIERS;
            synchronized (hashMap) {
                BRAZIERS.put(this.func_174877_v(), this.getRange());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_145843_s() {
        super.func_145843_s();
        HashMap<BlockPos, Integer> hashMap = BRAZIERS;
        synchronized (hashMap) {
            BRAZIERS.remove(this.func_174877_v());
        }
    }
}

