/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.brazier.block.tile.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.possible_triangle.brazier.Brazier;
import com.possible_triangle.brazier.block.tile.BrazierTile;
import com.possible_triangle.brazier.config.ClientConfig;
import com.possible_triangle.brazier.entity.render.CrazedFlameRenderer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BrazierRenderer
extends TileEntityRenderer<BrazierTile> {
    public static TextureAtlasSprite RUNES;
    public static final RenderType RENDER_TYPE;
    private static final int TEXTURE_HEIGHT = 9;
    public static String TEXTURE_KEY;

    public BrazierRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public static void atlasStitch(AtlasTexture atlas, Consumer<ResourceLocation> sprites) {
        if (atlas.func_229223_g_().equals((Object)AtlasTexture.field_110575_b)) {
            sprites.accept(new ResourceLocation("brazier", TEXTURE_KEY));
        }
    }

    public static void atlasStitch(AtlasTexture atlas) {
        if (atlas.func_229223_g_().equals((Object)AtlasTexture.field_110575_b)) {
            RUNES = atlas.func_195424_a(new ResourceLocation("brazier", TEXTURE_KEY));
        }
    }

    private void renderTop(MatrixStack matrizes, float alpha, IRenderTypeBuffer buffer) {
        matrizes.func_227860_a_();
        matrizes.func_227861_a_(0.0, (double)0.05f, 0.0);
        Matrix4f matrix = matrizes.func_227866_c_().func_227870_a_();
        IVertexBuilder vertex = buffer.getBuffer(RENDER_TYPE);
        for (int i = 0; i < 4; ++i) {
            float v = RUNES.func_94212_f() - RUNES.func_94209_e();
            float start = v / 9.0f * (float)i * 2.0f;
            float minU = RUNES.func_94209_e() + start;
            float maxU = minU + v / 9.0f * 1.5f;
            matrizes.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(90.0f));
            vertex.func_227888_a_(matrix, 1.0f, 0.0f, -0.25f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(maxU, RUNES.func_94206_g()).func_227886_a_(0xF000F0).func_181675_d();
            vertex.func_227888_a_(matrix, 1.0f, 0.0f, 0.25f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(maxU, RUNES.func_94210_h()).func_227886_a_(0xF000F0).func_181675_d();
            vertex.func_227888_a_(matrix, 2.5f, 0.0f, 0.25f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(minU, RUNES.func_94210_h()).func_227886_a_(0xF000F0).func_181675_d();
            vertex.func_227888_a_(matrix, 2.5f, 0.0f, -0.25f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(minU, RUNES.func_94206_g()).func_227886_a_(0xF000F0).func_181675_d();
        }
        matrizes.func_227865_b_();
    }

    private void renderSide(MatrixStack matrizes, float alpha, IRenderTypeBuffer buffer, int height) {
        matrizes.func_227860_a_();
        int times = height / 9;
        for (int quarter = 0; quarter < 4; ++quarter) {
            matrizes.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(90.0f));
            for (int i = 0; i <= times; ++i) {
                float segment = Math.min(9, height - i * 9);
                float offset = i * 9;
                matrizes.func_227860_a_();
                matrizes.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(90.0f));
                matrizes.func_227861_a_(0.0, (double)2.55f, 0.0);
                Matrix4f matrix = matrizes.func_227866_c_().func_227870_a_();
                IVertexBuilder vertex = buffer.getBuffer(RENDER_TYPE);
                float maxU = RUNES.func_94209_e() + segment * ((RUNES.func_94212_f() - RUNES.func_94209_e()) / 9.0f);
                vertex.func_227888_a_(matrix, offset, 0.0f, -0.25f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(RUNES.func_94209_e(), RUNES.func_94206_g()).func_227886_a_(0xF000F0).func_181675_d();
                vertex.func_227888_a_(matrix, offset, 0.0f, 0.25f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(RUNES.func_94209_e(), RUNES.func_94210_h()).func_227886_a_(0xF000F0).func_181675_d();
                vertex.func_227888_a_(matrix, offset + segment, 0.0f, 0.25f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(maxU, RUNES.func_94210_h()).func_227886_a_(0xF000F0).func_181675_d();
                vertex.func_227888_a_(matrix, offset + segment, 0.0f, -0.25f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(maxU, RUNES.func_94206_g()).func_227886_a_(0xF000F0).func_181675_d();
                matrizes.func_227865_b_();
            }
        }
        matrizes.func_227865_b_();
    }

    private void renderFlame(MatrixStack matrizes, IRenderTypeBuffer buffer, int light) {
        CrazedFlameRenderer.renderFlame(matrizes, Minecraft.func_71410_x().func_175598_ae(), buffer, light);
    }

    public void render(BrazierTile tile, float partialTicks, MatrixStack matrizes, IRenderTypeBuffer buffer, int light, int overlay) {
        int height = tile.getHeight();
        float alpha = 1.0f;
        if (height > 0) {
            matrizes.func_227860_a_();
            matrizes.func_227861_a_(0.5, 0.0, 0.5);
            if (((ClientConfig)Brazier.CLIENT_CONFIG.get()).RENDER_RUNES) {
                Stream.of(Vector3f.field_229179_b_, Vector3f.field_229178_a_, Vector3f.field_229182_e_, Vector3f.field_229183_f_).forEach(v -> {
                    this.renderSide(matrizes, alpha, buffer, height);
                    this.renderTop(matrizes, alpha, buffer);
                });
            }
            matrizes.func_227860_a_();
            matrizes.func_227861_a_(0.0, (double)1.4f, 0.0);
            this.renderFlame(matrizes, buffer, light);
            matrizes.func_227865_b_();
            matrizes.func_227865_b_();
        }
    }

    static {
        TEXTURE_KEY = "block/brazier_runes";
        RenderType.State glState = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(AtlasTexture.field_110575_b, false, true)).func_228716_a_(new RenderState.DiffuseLightingState(true)).func_228713_a_(new RenderState.AlphaState(0.004f)).func_228719_a_(new RenderState.LightmapState(true)).func_228728_a_(false);
        RENDER_TYPE = RenderType.func_228632_a_((String)"brazier:runes", (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)128, (RenderType.State)glState);
    }
}

