/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.brazier.forge.compat.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.possible_triangle.brazier.Content;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class LightOnBrazier
implements IRecipeCategory<Recipe> {
    public static final ResourceLocation UID = new ResourceLocation("brazier", "light_on_brazier");
    private static List<ItemStack> BRAZIER_LIST = null;
    private static final int HEIGHT = 32;
    private static final int WIDTH = 96;
    private final IDrawable background;
    private final IDrawable icon;
    private final String display;

    public static List<ItemStack> getBrazier() {
        if (BRAZIER_LIST == null) {
            BRAZIER_LIST = Collections.singletonList(new ItemStack((IItemProvider)Content.BRAZIER.get()));
        }
        return BRAZIER_LIST;
    }

    public LightOnBrazier(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(96, 32);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)Content.ICON.get()));
        this.display = I18n.func_135052_a((String)("category." + UID.func_110624_b() + "." + UID.func_110623_a()), (Object[])new Object[0]);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends Recipe> getRecipeClass() {
        return Recipe.class;
    }

    public String getTitle() {
        return this.display;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(Recipe recipe, IIngredients ingredients) {
        List<ItemStack> items = Arrays.asList(recipe.input.func_193365_a());
        ingredients.setInputLists(VanillaTypes.ITEM, Stream.of(items, LightOnBrazier.getBrazier()).collect(Collectors.toList()));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)new ItemStack((IItemProvider)recipe.output));
    }

    public void setRecipe(IRecipeLayout layout, Recipe recipe, IIngredients ingredients) {
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        layout.getItemStacks().init(0, true, 39, 7);
        layout.getItemStacks().set(0, new ItemStack((IItemProvider)Content.ICON.get()));
        layout.getItemStacks().init(1, true, 10, 7);
        layout.getItemStacks().set(1, (List)inputs.get(0));
        layout.getItemStacks().init(2, false, 71, 7);
        layout.getItemStacks().set(2, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    public void draw(Recipe recipe, MatrixStack matrizes, double mouseX, double mouseY) {
    }

    public static class Recipe {
        public final Ingredient input;
        public final Item output;

        public Recipe(Ingredient input, Item output) {
            this.input = input;
            this.output = output;
        }
    }
}

