/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.brazier.forge.data;

import com.google.gson.JsonObject;
import com.possible_triangle.brazier.Conditional;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class LootInjectModifier
extends LootModifier {
    private boolean enabled;

    @SubscribeEvent
    public static void registerModifierSerializers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)new Serializer().setRegistryName(new ResourceLocation("brazier", "loot_inject")));
    }

    private LootInjectModifier(boolean enabled, ILootCondition[] conditions) {
        super(Optional.ofNullable(conditions).orElse(new ILootCondition[0]));
        this.enabled = enabled;
    }

    @NotNull
    protected List<ItemStack> doApply(List<ItemStack> list, LootContext ctx) {
        if (this.enabled) {
            Conditional.injectLoot(ctx.getQueriedLootTableId(), builder -> {
                LootPool pool = builder.func_216044_b();
                pool.func_216091_a(list::add, ctx);
            });
        }
        return list;
    }

    private static class Serializer
    extends GlobalLootModifierSerializer<LootInjectModifier> {
        private Serializer() {
        }

        public JsonObject write(LootInjectModifier modifier) {
            JsonObject json = new JsonObject();
            json.addProperty("enabled", Boolean.valueOf(modifier.enabled));
            return json;
        }

        public LootInjectModifier read(ResourceLocation name, JsonObject object, ILootCondition[] conditions) {
            return new LootInjectModifier(object.get("enabled").getAsBoolean(), conditions);
        }
    }
}

