/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.brazier.item;

import java.util.Objects;
import me.shedaniel.architectury.registry.RegistrySupplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.AbstractSpawner;

public class LazySpawnEgg
extends Item {
    private final int primary;
    private final int secondary;
    private final RegistrySupplier<EntityType<?>> type;

    public LazySpawnEgg(RegistrySupplier<EntityType<?>> type, int primary, int secondary) {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78026_f));
        this.primary = primary;
        this.secondary = secondary;
        this.type = type;
    }

    public ActionResultType func_195939_a(ItemUseContext useOnContext) {
        TileEntity tile;
        World world = useOnContext.func_195991_k();
        EntityType type = (EntityType)this.type.get();
        if (!(world instanceof ServerWorld)) {
            return ActionResultType.SUCCESS;
        }
        ItemStack stack = useOnContext.func_195996_i();
        BlockPos pos = useOnContext.func_195995_a();
        Direction direction = useOnContext.func_196000_l();
        BlockState state = world.func_180495_p(pos);
        if (state.func_203425_a(Blocks.field_150474_ac) && (tile = world.func_175625_s(pos)) instanceof MobSpawnerTileEntity) {
            AbstractSpawner baseSpawner = ((MobSpawnerTileEntity)tile).func_145881_a();
            baseSpawner.func_200876_a(type);
            tile.func_70296_d();
            world.func_184138_a(pos, state, state, 3);
            stack.func_190918_g(1);
            return ActionResultType.CONSUME;
        }
        BlockPos spawnAt = state.func_196952_d((IBlockReader)world, pos).func_197766_b() ? pos : pos.func_177972_a(direction);
        if (type.func_220331_a((ServerWorld)world, stack, useOnContext.func_195999_j(), spawnAt, SpawnReason.SPAWN_EGG, true, !Objects.equals(pos, spawnAt) && direction == Direction.UP) != null) {
            stack.func_190918_g(1);
        }
        return ActionResultType.CONSUME;
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand interactionHand) {
        EntityType type = (EntityType)this.type.get();
        ItemStack itemStack = player.func_184586_b(interactionHand);
        BlockRayTraceResult hitResult = LazySpawnEgg.func_219968_a((World)level, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (hitResult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResult.func_226250_c_((Object)itemStack);
        }
        if (!(level instanceof ServerWorld)) {
            return ActionResult.func_226248_a_((Object)itemStack);
        }
        BlockPos blockPos = hitResult.func_216350_a();
        if (!(level.func_180495_p(blockPos).func_177230_c() instanceof FlowingFluidBlock)) {
            return ActionResult.func_226250_c_((Object)itemStack);
        }
        if (level.func_175660_a(player, blockPos) && player.func_175151_a(blockPos, hitResult.func_216354_b(), itemStack)) {
            if (type.func_220331_a((ServerWorld)level, itemStack, player, blockPos, SpawnReason.SPAWN_EGG, false, false) == null) {
                return ActionResult.func_226250_c_((Object)itemStack);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                itemStack.func_190918_g(1);
            }
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            return ActionResult.func_226249_b_((Object)itemStack);
        }
        return ActionResult.func_226251_d_((Object)itemStack);
    }

    public static int getColor(ItemStack stack, int index) {
        Item item = stack.func_77973_b();
        if (item instanceof LazySpawnEgg) {
            LazySpawnEgg egg = (LazySpawnEgg)item;
            return index == 0 ? egg.primary : egg.secondary;
        }
        return -1;
    }
}

