/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.content.contraptions.fluids.particle.FluidParticleData;
import com.simibubi.create.content.contraptions.particle.AirFlowParticleData;
import com.simibubi.create.content.contraptions.particle.AirParticleData;
import com.simibubi.create.content.contraptions.particle.CubeParticleData;
import com.simibubi.create.content.contraptions.particle.HeaterParticleData;
import com.simibubi.create.content.contraptions.particle.ICustomParticleData;
import com.simibubi.create.content.contraptions.particle.RotationIndicatorParticleData;
import com.simibubi.create.foundation.utility.Lang;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;

public enum AllParticleTypes {
    ROTATION_INDICATOR(RotationIndicatorParticleData::new),
    AIR_FLOW(AirFlowParticleData::new),
    AIR(AirParticleData::new),
    HEATER_PARTICLE(HeaterParticleData::new),
    CUBE(CubeParticleData::new),
    FLUID_PARTICLE(FluidParticleData::new),
    BASIN_FLUID(FluidParticleData::new),
    FLUID_DRIP(FluidParticleData::new);

    private ParticleEntry<?> entry;

    private <D extends IParticleData> AllParticleTypes(Supplier<? extends ICustomParticleData<D>> typeFactory) {
        String asId = Lang.asId(this.name());
        this.entry = new ParticleEntry(new ResourceLocation("create", asId), typeFactory);
    }

    public static void register(RegistryEvent.Register<ParticleType<?>> event) {
        for (AllParticleTypes particle : AllParticleTypes.values()) {
            particle.entry.register(event.getRegistry());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerFactories(ParticleFactoryRegisterEvent event) {
        ParticleManager particles = Minecraft.func_71410_x().field_71452_i;
        for (AllParticleTypes particle : AllParticleTypes.values()) {
            particle.entry.registerFactory(particles);
        }
    }

    public ParticleType<?> get() {
        return this.entry.getOrCreateType();
    }

    public String parameter() {
        return Lang.asId(this.name());
    }

    private class ParticleEntry<D extends IParticleData> {
        Supplier<? extends ICustomParticleData<D>> typeFactory;
        ParticleType<D> type;
        ResourceLocation id;

        public ParticleEntry(ResourceLocation id, Supplier<? extends ICustomParticleData<D>> typeFactory) {
            this.id = id;
            this.typeFactory = typeFactory;
        }

        void register(IForgeRegistry<ParticleType<?>> registry) {
            registry.register(this.getOrCreateType());
        }

        ParticleType<D> getOrCreateType() {
            if (this.type != null) {
                return this.type;
            }
            this.type = this.typeFactory.get().createType();
            this.type.setRegistryName(this.id);
            return this.type;
        }

        @OnlyIn(value=Dist.CLIENT)
        void registerFactory(ParticleManager particles) {
            this.typeFactory.get().register(this.getOrCreateType(), particles);
        }
    }
}

