/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.base;

import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.foundation.render.backend.core.BasicData;
import com.simibubi.create.foundation.render.backend.instancing.InstancedModel;
import com.simibubi.create.foundation.utility.ColorHelper;
import java.nio.ByteBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;

public class KineticData
extends BasicData {
    private float x;
    private float y;
    private float z;
    private float rotationalSpeed;
    private float rotationOffset;

    protected KineticData(InstancedModel<?> owner) {
        super(owner);
    }

    public KineticData setPosition(BlockPos pos) {
        return this.setPosition(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public KineticData setPosition(Vector3f pos) {
        return this.setPosition(pos.func_195899_a(), pos.func_195900_b(), pos.func_195902_c());
    }

    public KineticData setPosition(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.markDirty();
        return this;
    }

    public KineticData nudge(float x, float y, float z) {
        this.x += x;
        this.y += y;
        this.z += z;
        this.markDirty();
        return this;
    }

    public KineticData setColor(KineticTileEntity te) {
        if (te.hasSource()) {
            this.setColor(te.network);
        } else {
            this.setColor(255, 255, 0);
        }
        return this;
    }

    public KineticData setColor(Long l) {
        if (l != null) {
            return this.setColor((long)l);
        }
        this.setColor(255, 255, 255);
        return this;
    }

    private KineticData setColor(long l) {
        int color = ColorHelper.colorFromLong(l);
        byte r = (byte)(color >> 16 & 0xFF);
        byte g = (byte)(color >> 8 & 0xFF);
        byte b = (byte)(color & 0xFF);
        this.setColor(r, g, b);
        return this;
    }

    public KineticData setRotationalSpeed(float rotationalSpeed) {
        this.rotationalSpeed = rotationalSpeed;
        return this;
    }

    public KineticData setRotationOffset(float rotationOffset) {
        this.rotationOffset = rotationOffset;
        return this;
    }

    @Override
    public void write(ByteBuffer buf) {
        super.write(buf);
        buf.asFloatBuffer().put(new float[]{this.x, this.y, this.z, this.rotationalSpeed, this.rotationOffset});
        buf.position(buf.position() + 20);
    }
}

