/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.simibubi.create.content.contraptions.components.actors.PortableStorageInterfaceTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class PortableFluidInterfaceTileEntity
extends PortableStorageInterfaceTileEntity {
    protected LazyOptional<IFluidHandler> capability = this.createEmptyHandler();

    public PortableFluidInterfaceTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public void startTransferringTo(Contraption contraption, float distance) {
        LazyOptional<IFluidHandler> oldcap = this.capability;
        this.capability = LazyOptional.of(() -> new InterfaceFluidHandler(contraption.fluidInventory));
        oldcap.invalidate();
        super.startTransferringTo(contraption, distance);
    }

    @Override
    protected void invalidateCapability() {
        this.capability.invalidate();
    }

    @Override
    protected void stopTransferring() {
        LazyOptional<IFluidHandler> oldcap = this.capability;
        this.capability = this.createEmptyHandler();
        oldcap.invalidate();
        super.stopTransferring();
    }

    private LazyOptional<IFluidHandler> createEmptyHandler() {
        return LazyOptional.of(() -> new InterfaceFluidHandler((IFluidHandler)new FluidTank(0)));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.isFluidHandlerCap(cap)) {
            return this.capability.cast();
        }
        return super.getCapability(cap, side);
    }

    class InterfaceFluidHandler
    implements IFluidHandler {
        private IFluidHandler wrapped;

        public InterfaceFluidHandler(IFluidHandler wrapped) {
            this.wrapped = wrapped;
        }

        public int getTanks() {
            return this.wrapped.getTanks();
        }

        public FluidStack getFluidInTank(int tank) {
            return this.wrapped.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return this.wrapped.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return this.wrapped.isFluidValid(tank, stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!PortableFluidInterfaceTileEntity.this.isConnected()) {
                return 0;
            }
            int fill = this.wrapped.fill(resource, action);
            if (fill > 0 && action.execute()) {
                PortableFluidInterfaceTileEntity.this.onContentTransferred();
            }
            return fill;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!PortableFluidInterfaceTileEntity.this.canTransfer()) {
                return FluidStack.EMPTY;
            }
            FluidStack drain = this.wrapped.drain(resource, action);
            if (!drain.isEmpty() && action.execute()) {
                PortableFluidInterfaceTileEntity.this.onContentTransferred();
            }
            return drain;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (!PortableFluidInterfaceTileEntity.this.canTransfer()) {
                return FluidStack.EMPTY;
            }
            FluidStack drain = this.wrapped.drain(maxDrain, action);
            if (!drain.isEmpty() && (action.execute() || drain.getAmount() == 1)) {
                PortableFluidInterfaceTileEntity.this.onContentTransferred();
            }
            return drain;
        }
    }
}

