/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.content.contraptions.components.actors.BlockBreakingMovementBehaviour;
import com.simibubi.create.content.contraptions.components.saw.SawBlock;
import com.simibubi.create.content.contraptions.components.saw.SawRenderer;
import com.simibubi.create.content.contraptions.components.saw.SawTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.foundation.utility.TreeCutter;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class SawMovementBehaviour
extends BlockBreakingMovementBehaviour {
    @Override
    public boolean isActive(MovementContext context) {
        return !VecHelper.isVecPointingTowards(context.relativeMotion, ((Direction)context.state.func_177229_b((Property)SawBlock.FACING)).func_176734_d());
    }

    @Override
    public Vector3d getActiveAreaOffset(MovementContext context) {
        return Vector3d.func_237491_b_((Vector3i)((Direction)context.state.func_177229_b((Property)SawBlock.FACING)).func_176730_m()).func_186678_a((double)0.65f);
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        super.visitNewPosition(context, pos);
        Vector3d facingVec = Vector3d.func_237491_b_((Vector3i)((Direction)context.state.func_177229_b((Property)SawBlock.FACING)).func_176730_m());
        facingVec = (Vector3d)context.rotation.apply(facingVec);
        Direction closestToFacing = Direction.func_210769_a((double)facingVec.field_72450_a, (double)facingVec.field_72448_b, (double)facingVec.field_72449_c);
        if (closestToFacing.func_176740_k().func_200128_b() && context.data.func_74764_b("BreakingPos")) {
            context.data.func_82580_o("BreakingPos");
            context.stall = false;
        }
    }

    @Override
    public boolean canBreak(World world, BlockPos breakingPos, BlockState state) {
        return super.canBreak(world, breakingPos, state) && SawTileEntity.isSawable(state);
    }

    @Override
    protected void onBlockBroken(MovementContext context, BlockPos pos, BlockState brokenState) {
        if (brokenState.func_235714_a_((ITag)BlockTags.field_206952_E)) {
            return;
        }
        TreeCutter.findTree((IBlockReader)context.world, pos).destroyBlocks(context.world, null, (stack, dropPos) -> this.dropItemFromCutTree(context, (BlockPos)stack, (ItemStack)dropPos));
    }

    public void dropItemFromCutTree(MovementContext context, BlockPos pos, ItemStack stack) {
        ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)context.contraption.inventory, (ItemStack)stack, (boolean)false);
        if (remainder.func_190926_b()) {
            return;
        }
        World world = context.world;
        Vector3d dropPos = VecHelper.getCenterOf((Vector3i)pos);
        float distance = (float)dropPos.func_72438_d(context.position);
        ItemEntity entity = new ItemEntity(world, dropPos.field_72450_a, dropPos.field_72448_b, dropPos.field_72449_c, remainder);
        entity.func_213317_d(context.relativeMotion.func_186678_a((double)(distance / 20.0f)));
        world.func_217376_c((Entity)entity);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderInContraption(MovementContext context, MatrixStack ms, MatrixStack msLocal, IRenderTypeBuffer buffer) {
        SawRenderer.renderInContraption(context, ms, msLocal, buffer);
    }

    @Override
    protected DamageSource getDamageSource() {
        return SawBlock.damageSourceSaw;
    }
}

