/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.bearing;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.BearingBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.IBearingTileEntity;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.render.backend.FastRenderDispatcher;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;

public class BearingRenderer
extends KineticTileEntityRenderer {
    public BearingRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        if (FastRenderDispatcher.available(te.func_145831_w())) {
            return;
        }
        super.renderSafe(te, partialTicks, ms, buffer, light, overlay);
        IBearingTileEntity bearingTe = (IBearingTileEntity)((Object)te);
        Direction facing = (Direction)te.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H);
        AllBlockPartials top = bearingTe.isWoodenTop() ? AllBlockPartials.BEARING_TOP_WOODEN : AllBlockPartials.BEARING_TOP;
        SuperByteBuffer superBuffer = top.renderOn(te.func_195044_w());
        float interpolatedAngle = bearingTe.getInterpolatedAngle(partialTicks - 1.0f);
        BearingRenderer.kineticRotationTransform(superBuffer, te, facing.func_176740_k(), (float)((double)(interpolatedAngle / 180.0f) * Math.PI), light);
        if (facing.func_176740_k().func_176722_c()) {
            superBuffer.rotateCentered(Direction.UP, AngleHelper.rad(AngleHelper.horizontalAngle(facing.func_176734_d())));
        }
        superBuffer.rotateCentered(Direction.EAST, AngleHelper.rad(-90.0f - AngleHelper.verticalAngle(facing)));
        superBuffer.renderInto(ms, buffer.getBuffer(RenderType.func_228639_c_()));
    }

    @Override
    protected SuperByteBuffer getRotatedModel(KineticTileEntity te) {
        return AllBlockPartials.SHAFT_HALF.renderOnDirectionalSouth(te.func_195044_w(), ((Direction)te.func_195044_w().func_177229_b((Property)BearingBlock.FACING)).func_176734_d());
    }
}

