/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.tracks;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.item.minecart.FurnaceMinecartEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ControllerRailBlock
extends AbstractRailBlock
implements IWrenchable {
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.field_208166_S;
    public static final BooleanProperty BACKWARDS = BooleanProperty.func_177716_a((String)"backwards");
    public static final IntegerProperty POWER = BlockStateProperties.field_208136_ak;

    public ControllerRailBlock(AbstractBlock.Properties properties) {
        super(true, properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)POWER, (Comparable)Integer.valueOf(0))).func_206870_a((Property)BACKWARDS, (Comparable)Boolean.valueOf(false))).func_206870_a(SHAPE, (Comparable)RailShape.NORTH_SOUTH));
    }

    public static Vector3i getAccelerationVector(BlockState state) {
        Direction pointingTo = ControllerRailBlock.getPointingTowards(state);
        return (ControllerRailBlock.isStateBackwards(state) ? pointingTo.func_176734_d() : pointingTo).func_176730_m();
    }

    private static Direction getPointingTowards(BlockState state) {
        switch ((RailShape)state.func_177229_b(SHAPE)) {
            case ASCENDING_WEST: 
            case EAST_WEST: {
                return Direction.WEST;
            }
            case ASCENDING_EAST: {
                return Direction.EAST;
            }
            case ASCENDING_SOUTH: {
                return Direction.SOUTH;
            }
        }
        return Direction.NORTH;
    }

    protected BlockState func_208489_a(World world, BlockPos pos, BlockState state, boolean p_208489_4_) {
        BlockState updatedState = super.func_208489_a(world, pos, state, p_208489_4_);
        if (updatedState.func_177229_b(SHAPE) == state.func_177229_b(SHAPE)) {
            return updatedState;
        }
        BlockState reversedUpdatedState = updatedState;
        if (ControllerRailBlock.getPointingTowards(state).func_176740_k() != ControllerRailBlock.getPointingTowards(updatedState).func_176740_k()) {
            for (boolean opposite : Iterate.trueAndFalse) {
                Direction offset = ControllerRailBlock.getPointingTowards(updatedState);
                if (opposite) {
                    offset = offset.func_176734_d();
                }
                for (BlockPos adjPos : Iterate.hereBelowAndAbove(pos.func_177972_a(offset))) {
                    BlockState adjState = world.func_180495_p(adjPos);
                    if (!AllBlocks.CONTROLLER_RAIL.has(adjState) || ControllerRailBlock.getPointingTowards(adjState).func_176740_k() != offset.func_176740_k() || adjState.func_177229_b((Property)BACKWARDS) == reversedUpdatedState.func_177229_b((Property)BACKWARDS)) continue;
                    reversedUpdatedState = (BlockState)reversedUpdatedState.func_235896_a_((Property)BACKWARDS);
                }
            }
        }
        if (reversedUpdatedState != updatedState) {
            world.func_175656_a(pos, reversedUpdatedState);
        }
        return reversedUpdatedState;
    }

    private static void decelerateCart(BlockPos pos, AbstractMinecartEntity cart) {
        Vector3d diff = VecHelper.getCenterOf((Vector3i)pos).func_178788_d(cart.func_213303_ch());
        cart.func_213293_j(diff.field_72450_a / 16.0, 0.0, diff.field_72449_c / 16.0);
        if (cart instanceof FurnaceMinecartEntity) {
            FurnaceMinecartEntity fme = (FurnaceMinecartEntity)cart;
            fme.field_94109_b = 0.0;
            fme.field_94111_a = 0.0;
        }
    }

    private static boolean isStableWith(BlockState testState, IBlockReader world, BlockPos pos) {
        return ControllerRailBlock.func_220064_c((IBlockReader)world, (BlockPos)pos.func_177977_b()) && (!((RailShape)testState.func_177229_b(SHAPE)).func_208092_c() || ControllerRailBlock.func_220064_c((IBlockReader)world, (BlockPos)pos.func_177972_a(ControllerRailBlock.getPointingTowards(testState))));
    }

    public BlockState func_196258_a(BlockItemUseContext p_196258_1_) {
        Direction direction = p_196258_1_.func_195992_f();
        BlockState base = super.func_196258_a(p_196258_1_);
        return (BlockState)(base == null ? this.func_176223_P() : base).func_206870_a((Property)BACKWARDS, (Comparable)Boolean.valueOf(direction.func_176743_c() == Direction.AxisDirection.POSITIVE));
    }

    public Property<RailShape> func_176560_l() {
        return SHAPE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{SHAPE, POWER, BACKWARDS});
    }

    public void onMinecartPass(BlockState state, World world, BlockPos pos, AbstractMinecartEntity cart) {
        Vector3d motion;
        if (world.field_72995_K) {
            return;
        }
        Vector3d accelerationVec = Vector3d.func_237491_b_((Vector3i)ControllerRailBlock.getAccelerationVector(state));
        double targetSpeed = cart.getMaxSpeedWithRail() * (double)((Integer)state.func_177229_b((Property)POWER)).intValue() / 15.0;
        if (cart instanceof FurnaceMinecartEntity) {
            FurnaceMinecartEntity fme = (FurnaceMinecartEntity)cart;
            fme.field_94111_a = accelerationVec.field_72450_a;
            fme.field_94109_b = accelerationVec.field_72449_c;
        }
        if (((motion = cart.func_213322_ci()).func_72430_b(accelerationVec) >= 0.0 || motion.func_189985_c() < 1.0E-4) && targetSpeed > 0.0) {
            cart.func_213317_d(accelerationVec.func_186678_a(targetSpeed));
        } else {
            ControllerRailBlock.decelerateCart(pos, cart);
        }
    }

    protected void func_189541_b(BlockState state, World world, BlockPos pos, Block block) {
        int newPower = this.calculatePower(world, pos);
        if ((Integer)state.func_177229_b((Property)POWER) != newPower) {
            this.placeAndNotify((BlockState)state.func_206870_a((Property)POWER, (Comparable)Integer.valueOf(newPower)), pos, world);
        }
    }

    private int calculatePower(World world, BlockPos pos) {
        BlockPos testPos;
        int i;
        int newPower = world.func_175687_A(pos);
        if (newPower != 0) {
            return newPower;
        }
        int forwardDistance = 0;
        int backwardsDistance = 0;
        BlockPos lastForwardRail = pos;
        BlockPos lastBackwardsRail = pos;
        int forwardPower = 0;
        int backwardsPower = 0;
        for (i = 0; i < 15 && (testPos = this.findNextRail(lastForwardRail, (IBlockReader)world, false)) != null; ++i) {
            ++forwardDistance;
            lastForwardRail = testPos;
            forwardPower = world.func_175687_A(testPos);
            if (forwardPower != 0) break;
        }
        for (i = 0; i < 15 && (testPos = this.findNextRail(lastBackwardsRail, (IBlockReader)world, true)) != null; ++i) {
            ++backwardsDistance;
            lastBackwardsRail = testPos;
            backwardsPower = world.func_175687_A(testPos);
            if (backwardsPower != 0) break;
        }
        if (forwardDistance > 8 && backwardsDistance > 8) {
            return 0;
        }
        if (backwardsPower == 0 && forwardDistance <= 8) {
            return forwardPower;
        }
        if (forwardPower == 0 && backwardsDistance <= 8) {
            return backwardsPower;
        }
        if (backwardsPower != 0 && forwardPower != 0) {
            return MathHelper.func_76143_f((double)((double)(backwardsPower * forwardDistance + forwardPower * backwardsDistance) / (double)(forwardDistance + backwardsDistance)));
        }
        return 0;
    }

    @Override
    public ActionResultType onWrenched(BlockState state, ItemUseContext context) {
        World world = context.func_195991_k();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        BlockPos pos = context.func_195995_a();
        for (Rotation testRotation : new Rotation[]{Rotation.CLOCKWISE_90, Rotation.CLOCKWISE_180, Rotation.COUNTERCLOCKWISE_90}) {
            BlockState testState = this.func_185499_a(state, testRotation);
            if (!ControllerRailBlock.isStableWith(testState, (IBlockReader)world, pos)) continue;
            this.placeAndNotify(testState, pos, world);
            break;
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public ActionResultType onSneakWrenched(BlockState state, ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState testState = (BlockState)state.func_206870_a((Property)BACKWARDS, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((Property)BACKWARDS) == false));
        if (ControllerRailBlock.isStableWith(testState, (IBlockReader)world, pos)) {
            this.placeAndNotify(testState, pos, world);
        }
        return ActionResultType.SUCCESS;
    }

    private void placeAndNotify(BlockState state, BlockPos pos, World world) {
        world.func_180501_a(pos, state, 3);
        world.func_195593_d(pos.func_177977_b(), (Block)this);
        if (((RailShape)state.func_177229_b(SHAPE)).func_208092_c()) {
            world.func_195593_d(pos.func_177984_a(), (Block)this);
        }
    }

    @Nullable
    private BlockPos findNextRail(BlockPos from, IBlockReader world, boolean reversed) {
        BlockState current = world.func_180495_p(from);
        if (!(current.func_177230_c() instanceof ControllerRailBlock)) {
            return null;
        }
        Vector3i accelerationVec = ControllerRailBlock.getAccelerationVector(current);
        BlockPos baseTestPos = reversed ? from.func_177973_b(accelerationVec) : from.func_177971_a(accelerationVec);
        for (BlockPos testPos : Iterate.hereBelowAndAbove(baseTestPos)) {
            BlockState testState;
            if (testPos.func_177956_o() > from.func_177956_o() && !((RailShape)current.func_177229_b(SHAPE)).func_208092_c() || !((testState = world.func_180495_p(testPos)).func_177230_c() instanceof ControllerRailBlock) || !ControllerRailBlock.getAccelerationVector(testState).equals((Object)accelerationVec)) continue;
            return testPos;
        }
        return null;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        return (Integer)state.func_177229_b((Property)POWER);
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        if (rotation == Rotation.NONE) {
            return state;
        }
        RailShape railshape = (RailShape)((BlockState)Blocks.field_196552_aC.func_176223_P().func_206870_a(SHAPE, state.func_177229_b(SHAPE))).func_185907_a(rotation).func_177229_b(SHAPE);
        state = (BlockState)state.func_206870_a(SHAPE, (Comparable)railshape);
        if (rotation == Rotation.CLOCKWISE_180 || ControllerRailBlock.getPointingTowards(state).func_176740_k() == Direction.Axis.Z == (rotation == Rotation.COUNTERCLOCKWISE_90)) {
            return (BlockState)state.func_235896_a_((Property)BACKWARDS);
        }
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        RailShape railshape = (RailShape)((BlockState)Blocks.field_196552_aC.func_176223_P().func_206870_a(SHAPE, state.func_177229_b(SHAPE))).func_185902_a(mirror).func_177229_b(SHAPE);
        if (ControllerRailBlock.getPointingTowards(state = (BlockState)state.func_206870_a(SHAPE, (Comparable)railshape)).func_176740_k() == Direction.Axis.Z == (mirror == Mirror.LEFT_RIGHT)) {
            return (BlockState)state.func_235896_a_((Property)BACKWARDS);
        }
        return state;
    }

    public static boolean isStateBackwards(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BACKWARDS) ^ ControllerRailBlock.isReversedSlope(state);
    }

    public static boolean isReversedSlope(BlockState state) {
        return state.func_177229_b(SHAPE) == RailShape.ASCENDING_SOUTH || state.func_177229_b(SHAPE) == RailShape.ASCENDING_EAST;
    }
}

