/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.contraptions.fluids.PipeConnection;
import com.simibubi.create.content.contraptions.fluids.PumpBlock;
import com.simibubi.create.content.contraptions.fluids.PumpTileEntity;
import com.simibubi.create.content.contraptions.fluids.pipes.AxisPipeBlock;
import com.simibubi.create.content.contraptions.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class FluidPropagator {
    public static void propagateChangedPipe(IWorld world, BlockPos pipePos, BlockState pipeState) {
        ArrayList<Pair<Integer, BlockPos>> frontier = new ArrayList<Pair<Integer, BlockPos>>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        HashSet<Pair<PumpTileEntity, Direction>> discoveredPumps = new HashSet<Pair<PumpTileEntity, Direction>>();
        frontier.add(Pair.of(0, pipePos));
        while (!frontier.isEmpty()) {
            Pair pair2 = (Pair)frontier.remove(0);
            BlockPos currentPos = (BlockPos)pair2.getSecond();
            if (visited.contains(currentPos)) continue;
            visited.add(currentPos);
            BlockState currentState = currentPos.equals((Object)pipePos) ? pipeState : world.func_180495_p(currentPos);
            FluidTransportBehaviour pipe = FluidPropagator.getPipe((IBlockReader)world, currentPos);
            if (pipe == null) continue;
            pipe.wipePressure();
            for (Direction direction : FluidPropagator.getPipeConnections(currentState, pipe)) {
                Integer distance;
                FluidTransportBehaviour targetPipe;
                BlockPos target = currentPos.func_177972_a(direction);
                if (!world.isAreaLoaded(target, 0)) continue;
                TileEntity tileEntity = world.func_175625_s(target);
                BlockState targetState = world.func_180495_p(target);
                if (tileEntity instanceof PumpTileEntity) {
                    if (!AllBlocks.MECHANICAL_PUMP.has(targetState) || ((Direction)targetState.func_177229_b((Property)PumpBlock.FACING)).func_176740_k() != direction.func_176740_k()) continue;
                    discoveredPumps.add(Pair.of((PumpTileEntity)tileEntity, direction.func_176734_d()));
                    continue;
                }
                if (visited.contains(target) || (targetPipe = FluidPropagator.getPipe((IBlockReader)world, target)) == null || (distance = (Integer)pair2.getFirst()) >= FluidPropagator.getPumpRange() && !targetPipe.hasAnyPressure() || !targetPipe.canHaveFlowToward(targetState, direction.func_176734_d())) continue;
                frontier.add(Pair.of(distance + 1, target));
            }
        }
        discoveredPumps.forEach(pair -> ((PumpTileEntity)pair.getFirst()).updatePipesOnSide((Direction)pair.getSecond()));
    }

    public static void resetAffectedFluidNetworks(World world, BlockPos start, Direction side) {
        ArrayList<BlockPos> frontier = new ArrayList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        frontier.add(start);
        while (!frontier.isEmpty()) {
            BlockPos pos = (BlockPos)frontier.remove(0);
            if (visited.contains(pos)) continue;
            visited.add(pos);
            FluidTransportBehaviour pipe = FluidPropagator.getPipe((IBlockReader)world, pos);
            if (pipe == null) continue;
            for (Direction d : Iterate.directions) {
                PipeConnection connection;
                BlockPos target;
                if (pos.equals((Object)start) && d != side || visited.contains(target = pos.func_177972_a(d)) || (connection = pipe.getConnection(d)) == null || !connection.hasFlow()) continue;
                PipeConnection.Flow flow = connection.flow.get();
                if (!flow.inbound) continue;
                connection.resetNetwork();
                frontier.add(target);
            }
        }
    }

    public static Direction validateNeighbourChange(BlockState state, World world, BlockPos pos, Block otherBlock, BlockPos neighborPos, boolean isMoving) {
        if (world.field_72995_K) {
            return null;
        }
        if (otherBlock instanceof FluidPipeBlock) {
            return null;
        }
        if (otherBlock instanceof AxisPipeBlock) {
            return null;
        }
        if (otherBlock instanceof PumpBlock) {
            return null;
        }
        if (otherBlock instanceof FlowingFluidBlock) {
            return null;
        }
        if (FluidPropagator.getStraightPipeAxis(state) == null) {
            return null;
        }
        for (Direction d : Iterate.directions) {
            if (!pos.func_177972_a(d).equals((Object)neighborPos)) continue;
            return d;
        }
        return null;
    }

    public static FluidTransportBehaviour getPipe(IBlockReader reader, BlockPos pos) {
        return TileEntityBehaviour.get(reader, pos, FluidTransportBehaviour.TYPE);
    }

    public static boolean isOpenEnd(IBlockReader reader, BlockPos pos, Direction side) {
        BlockPos connectedPos = pos.func_177972_a(side);
        BlockState connectedState = reader.func_180495_p(connectedPos);
        FluidTransportBehaviour pipe = FluidPropagator.getPipe(reader, connectedPos);
        if (pipe != null && pipe.canHaveFlowToward(connectedState, side.func_176734_d())) {
            return false;
        }
        if (PumpBlock.isPump(connectedState) && ((Direction)connectedState.func_177229_b((Property)PumpBlock.FACING)).func_176740_k() == side.func_176740_k()) {
            return false;
        }
        if (connectedState.func_235901_b_((Property)BlockStateProperties.field_227036_ao_)) {
            return true;
        }
        if (BlockHelper.hasBlockSolidSide(connectedState, reader, connectedPos, side.func_176734_d())) {
            return false;
        }
        return connectedState.func_185904_a().func_76222_j() && connectedState.func_185887_b(reader, connectedPos) != -1.0f || connectedState.func_235901_b_((Property)BlockStateProperties.field_208198_y);
    }

    public static List<Direction> getPipeConnections(BlockState state, FluidTransportBehaviour pipe) {
        ArrayList<Direction> list = new ArrayList<Direction>();
        for (Direction d : Iterate.directions) {
            if (!pipe.canHaveFlowToward(state, d)) continue;
            list.add(d);
        }
        return list;
    }

    public static int getPumpRange() {
        return (Integer)AllConfigs.SERVER.fluids.mechanicalPumpRange.get();
    }

    public static boolean hasFluidCapability(IBlockReader world, BlockPos pos, Direction side) {
        TileEntity tileEntity = world.func_175625_s(pos);
        return tileEntity != null && tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side).isPresent();
    }

    @Nullable
    public static Direction.Axis getStraightPipeAxis(BlockState state) {
        if (state.func_177230_c() instanceof PumpBlock) {
            return ((Direction)state.func_177229_b((Property)PumpBlock.FACING)).func_176740_k();
        }
        if (state.func_177230_c() instanceof AxisPipeBlock) {
            return (Direction.Axis)state.func_177229_b((Property)AxisPipeBlock.field_176298_M);
        }
        if (!FluidPipeBlock.isPipe(state)) {
            return null;
        }
        Direction.Axis axisFound = null;
        int connections = 0;
        for (Direction.Axis axis : Iterate.axes) {
            Direction d1 = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)axis);
            Direction d2 = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
            boolean openAt1 = FluidPipeBlock.isOpenAt(state, d1);
            boolean openAt2 = FluidPipeBlock.isOpenAt(state, d2);
            if (openAt1) {
                ++connections;
            }
            if (openAt2) {
                ++connections;
            }
            if (!openAt1 || !openAt2) continue;
            if (axisFound != null) {
                return null;
            }
            axisFound = axis;
        }
        return connections == 2 ? axisFound : null;
    }
}

