/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids;

import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.contraptions.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.contraptions.relays.elementary.BracketedTileEntityBehaviour;
import com.simibubi.create.foundation.block.connected.BakedModelWrapperWithData;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class PipeAttachmentModel
extends BakedModelWrapperWithData {
    private static ModelProperty<PipeModelData> PIPE_PROPERTY = new ModelProperty();

    public PipeAttachmentModel(IBakedModel template) {
        super(template);
    }

    @Override
    protected ModelDataMap.Builder gatherModelData(ModelDataMap.Builder builder, IBlockDisplayReader world, BlockPos pos, BlockState state) {
        PipeModelData data = new PipeModelData();
        FluidTransportBehaviour transport = TileEntityBehaviour.get((IBlockReader)world, pos, FluidTransportBehaviour.TYPE);
        BracketedTileEntityBehaviour bracket = TileEntityBehaviour.get((IBlockReader)world, pos, BracketedTileEntityBehaviour.TYPE);
        if (transport != null) {
            for (Direction d : Iterate.directions) {
                data.putRim(d, transport.getRenderedRimAttachment(world, pos, state, d));
            }
        }
        if (bracket != null) {
            data.putBracket(bracket.getBracket());
        }
        data.setEncased(FluidPipeBlock.shouldDrawCasing(world, pos, state));
        return builder.withInitial(PIPE_PROPERTY, (Object)data);
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData data) {
        ModelDataMap modelDataMap;
        ArrayList<BakedQuad> quads = super.getQuads(state, side, rand, data);
        if (data instanceof ModelDataMap && (modelDataMap = (ModelDataMap)data).hasProperty(PIPE_PROPERTY)) {
            quads = new ArrayList<BakedQuad>(quads);
            this.addQuads(quads, state, side, rand, (IModelData)modelDataMap, (PipeModelData)modelDataMap.getData(PIPE_PROPERTY));
        }
        return quads;
    }

    private void addQuads(List<BakedQuad> quads, BlockState state, Direction side, Random rand, IModelData data, PipeModelData pipeData) {
        IBakedModel bracket;
        for (Direction d : Iterate.directions) {
            if (!pipeData.hasRim(d)) continue;
            quads.addAll(AllBlockPartials.PIPE_ATTACHMENTS.get((Object)pipeData.getRim(d)).get(d).get().getQuads(state, side, rand, data));
        }
        if (pipeData.isEncased()) {
            quads.addAll(AllBlockPartials.FLUID_PIPE_CASING.get().getQuads(state, side, rand, data));
        }
        if ((bracket = pipeData.getBracket()) != null) {
            quads.addAll(bracket.getQuads(state, side, rand, data));
        }
    }

    private class PipeModelData {
        FluidTransportBehaviour.AttachmentTypes[] rims = new FluidTransportBehaviour.AttachmentTypes[6];
        boolean encased;
        IBakedModel bracket;

        public PipeModelData() {
            Arrays.fill((Object[])this.rims, (Object)FluidTransportBehaviour.AttachmentTypes.NONE);
        }

        public void putBracket(BlockState state) {
            this.bracket = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        }

        public IBakedModel getBracket() {
            return this.bracket;
        }

        public void putRim(Direction face, FluidTransportBehaviour.AttachmentTypes rim) {
            this.rims[face.func_176745_a()] = rim;
        }

        public void setEncased(boolean encased) {
            this.encased = encased;
        }

        public boolean hasRim(Direction face) {
            return this.rims[face.func_176745_a()] != FluidTransportBehaviour.AttachmentTypes.NONE;
        }

        public FluidTransportBehaviour.AttachmentTypes getRim(Direction face) {
            return this.rims[face.func_176745_a()];
        }

        public boolean isEncased() {
            return this.encased;
        }
    }
}

