/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.particle;

import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.content.contraptions.fluids.particle.BasinFluidParticle;
import com.simibubi.create.content.contraptions.fluids.particle.FluidParticleData;
import com.simibubi.create.content.contraptions.fluids.potion.PotionFluid;
import com.simibubi.create.foundation.utility.ColorHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fluids.FluidStack;

public class FluidStackParticle
extends SpriteTexturedParticle {
    private final float field_217587_G;
    private final float field_217588_H;
    private FluidStack fluid;

    public static FluidStackParticle create(ParticleType<FluidParticleData> type, ClientWorld world, FluidStack fluid, double x, double y, double z, double vx, double vy, double vz) {
        if (type == AllParticleTypes.BASIN_FLUID.get()) {
            return new BasinFluidParticle(world, fluid, x, y, z, vx, vy, vz);
        }
        return new FluidStackParticle(world, fluid, x, y, z, vx, vy, vz);
    }

    public FluidStackParticle(ClientWorld world, FluidStack fluid, double x, double y, double z, double vx, double vy, double vz) {
        super(world, x, y, z, vx, vy, vz);
        this.fluid = fluid;
        this.func_217567_a((TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(fluid.getFluid().getAttributes().getStillTexture()));
        this.field_70545_g = 1.0f;
        this.field_70552_h = 0.8f;
        this.field_70553_i = 0.8f;
        this.field_70551_j = 0.8f;
        this.multiplyColor(fluid.getFluid().getAttributes().getColor(fluid));
        this.field_187129_i = vx;
        this.field_187130_j = vy;
        this.field_187131_k = vz;
        this.field_70544_f /= 2.0f;
        this.field_217587_G = this.field_187136_p.nextFloat() * 3.0f;
        this.field_217588_H = this.field_187136_p.nextFloat() * 3.0f;
    }

    protected int func_189214_a(float p_189214_1_) {
        int brightnessForRender = super.func_189214_a(p_189214_1_);
        int skyLight = brightnessForRender >> 20;
        int blockLight = brightnessForRender >> 4 & 0xF;
        blockLight = Math.max(blockLight, this.fluid.getFluid().getAttributes().getLuminosity(this.fluid));
        return skyLight << 20 | blockLight << 4;
    }

    protected void multiplyColor(int color) {
        this.field_70552_h *= (float)(color >> 16 & 0xFF) / 255.0f;
        this.field_70553_i *= (float)(color >> 8 & 0xFF) / 255.0f;
        this.field_70551_j *= (float)(color & 0xFF) / 255.0f;
    }

    protected float func_217563_c() {
        return this.field_217569_E.func_94214_a((double)((this.field_217587_G + 1.0f) / 4.0f * 16.0f));
    }

    protected float func_217564_d() {
        return this.field_217569_E.func_94214_a((double)(this.field_217587_G / 4.0f * 16.0f));
    }

    protected float func_217562_e() {
        return this.field_217569_E.func_94207_b((double)(this.field_217588_H / 4.0f * 16.0f));
    }

    protected float func_217560_f() {
        return this.field_217569_E.func_94207_b((double)((this.field_217588_H + 1.0f) / 4.0f * 16.0f));
    }

    public void func_189213_a() {
        super.func_189213_a();
        if (!this.canEvaporate()) {
            return;
        }
        if (this.field_187132_l) {
            this.func_187112_i();
        }
        if (!this.field_187133_m) {
            return;
        }
        if (!this.field_187132_l && this.field_187122_b.field_73012_v.nextFloat() < 0.125f) {
            return;
        }
        Vector3d rgb = ColorHelper.getRGB(this.fluid.getFluid().getAttributes().getColor(this.fluid));
        this.field_187122_b.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.field_187126_f, this.field_187127_g, this.field_187128_h, rgb.field_72450_a, rgb.field_72448_b, rgb.field_72449_c);
    }

    protected boolean canEvaporate() {
        return this.fluid.getFluid() instanceof PotionFluid;
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217601_a;
    }
}

