/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.potion;

import com.simibubi.create.AllFluids;
import com.simibubi.create.content.contraptions.fluids.VirtualFluid;
import com.simibubi.create.content.contraptions.fluids.potion.PotionFluidHandler;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.Collection;
import java.util.List;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PotionFluid
extends VirtualFluid {
    public PotionFluid(ForgeFlowingFluid.Properties properties) {
        super(properties);
    }

    public static FluidStack withEffects(int amount, Potion potion, List<EffectInstance> customEffects) {
        FluidStack fluidStack = new FluidStack(AllFluids.POTION.get().func_210198_f(), amount);
        PotionFluid.addPotionToFluidStack(fluidStack, potion);
        PotionFluid.appendEffects(fluidStack, customEffects);
        return fluidStack;
    }

    public static FluidStack addPotionToFluidStack(FluidStack fs, Potion potion) {
        ResourceLocation resourcelocation = ForgeRegistries.POTION_TYPES.getKey((IForgeRegistryEntry)potion);
        if (potion == Potions.field_185229_a) {
            fs.removeChildTag("Potion");
            return fs;
        }
        fs.getOrCreateTag().func_74778_a("Potion", resourcelocation.toString());
        return fs;
    }

    public static FluidStack appendEffects(FluidStack fs, Collection<EffectInstance> customEffects) {
        if (customEffects.isEmpty()) {
            return fs;
        }
        CompoundNBT compoundnbt = fs.getOrCreateTag();
        ListNBT listnbt = compoundnbt.func_150295_c("CustomPotionEffects", 9);
        for (EffectInstance effectinstance : customEffects) {
            listnbt.add((Object)effectinstance.func_82719_a(new CompoundNBT()));
        }
        compoundnbt.func_218657_a("CustomPotionEffects", (INBT)listnbt);
        return fs;
    }

    public static class PotionFluidAttributes
    extends FluidAttributes {
        public PotionFluidAttributes(FluidAttributes.Builder builder, Fluid fluid) {
            super(builder, fluid);
        }

        public int getColor(FluidStack stack) {
            CompoundNBT tag = stack.getOrCreateTag();
            int color = PotionUtils.func_185181_a((Collection)PotionUtils.func_185185_a((CompoundNBT)tag)) | 0xFF000000;
            return color;
        }

        public String getTranslationKey(FluidStack stack) {
            CompoundNBT tag = stack.getOrCreateTag();
            IItemProvider itemFromBottleType = PotionFluidHandler.itemFromBottleType(NBTHelper.readEnum(tag, "Bottle", BottleType.class));
            return PotionUtils.func_185187_c((CompoundNBT)tag).func_185174_b(itemFromBottleType.func_199767_j().func_77658_a() + ".effect.");
        }
    }

    public static enum BottleType {
        REGULAR,
        SPLASH,
        LINGERING;

    }
}

