/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.content.contraptions.particle.AirFlowParticle;
import com.simibubi.create.content.contraptions.particle.ICustomParticleDataWithSprite;
import java.util.Locale;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AirFlowParticleData
implements IParticleData,
ICustomParticleDataWithSprite<AirFlowParticleData> {
    public static final Codec<AirFlowParticleData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.fieldOf("x").forGetter(p -> p.posX), (App)Codec.INT.fieldOf("y").forGetter(p -> p.posY), (App)Codec.INT.fieldOf("z").forGetter(p -> p.posZ)).apply((Applicative)i, AirFlowParticleData::new));
    public static final IParticleData.IDeserializer<AirFlowParticleData> DESERIALIZER = new IParticleData.IDeserializer<AirFlowParticleData>(){

        public AirFlowParticleData deserialize(ParticleType<AirFlowParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int x = reader.readInt();
            reader.expect(' ');
            int y = reader.readInt();
            reader.expect(' ');
            int z = reader.readInt();
            return new AirFlowParticleData(x, y, z);
        }

        public AirFlowParticleData read(ParticleType<AirFlowParticleData> particleTypeIn, PacketBuffer buffer) {
            return new AirFlowParticleData(buffer.readInt(), buffer.readInt(), buffer.readInt());
        }
    };
    final int posX;
    final int posY;
    final int posZ;

    public AirFlowParticleData(Vector3i pos) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public AirFlowParticleData(int posX, int posY, int posZ) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public AirFlowParticleData() {
        this(0, 0, 0);
    }

    public ParticleType<?> func_197554_b() {
        return AllParticleTypes.AIR_FLOW.get();
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.writeInt(this.posX);
        buffer.writeInt(this.posY);
        buffer.writeInt(this.posZ);
    }

    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %d %d %d", AllParticleTypes.AIR_FLOW.parameter(), this.posX, this.posY, this.posZ);
    }

    @Override
    public IParticleData.IDeserializer<AirFlowParticleData> getDeserializer() {
        return DESERIALIZER;
    }

    @Override
    public Codec<AirFlowParticleData> getCodec(ParticleType<AirFlowParticleData> type) {
        return CODEC;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ParticleManager.IParticleMetaFactory<AirFlowParticleData> getMetaFactory() {
        return AirFlowParticle.Factory::new;
    }
}

