/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.content.contraptions.particle.CubeParticleData;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class CubeParticle
extends Particle {
    public static final Vector3d[] CUBE = new Vector3d[]{new Vector3d(1.0, 1.0, -1.0), new Vector3d(1.0, 1.0, 1.0), new Vector3d(-1.0, 1.0, 1.0), new Vector3d(-1.0, 1.0, -1.0), new Vector3d(-1.0, -1.0, -1.0), new Vector3d(-1.0, -1.0, 1.0), new Vector3d(1.0, -1.0, 1.0), new Vector3d(1.0, -1.0, -1.0), new Vector3d(-1.0, -1.0, 1.0), new Vector3d(-1.0, 1.0, 1.0), new Vector3d(1.0, 1.0, 1.0), new Vector3d(1.0, -1.0, 1.0), new Vector3d(1.0, -1.0, -1.0), new Vector3d(1.0, 1.0, -1.0), new Vector3d(-1.0, 1.0, -1.0), new Vector3d(-1.0, -1.0, -1.0), new Vector3d(-1.0, -1.0, -1.0), new Vector3d(-1.0, 1.0, -1.0), new Vector3d(-1.0, 1.0, 1.0), new Vector3d(-1.0, -1.0, 1.0), new Vector3d(1.0, -1.0, 1.0), new Vector3d(1.0, 1.0, 1.0), new Vector3d(1.0, 1.0, -1.0), new Vector3d(1.0, -1.0, -1.0)};
    public static final Vector3d[] CUBE_NORMALS = new Vector3d[]{new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.0, -1.0, 0.0), new Vector3d(0.0, 0.0, 1.0), new Vector3d(0.0, 0.0, 1.0), new Vector3d(0.0, 0.0, 1.0), new Vector3d(0.0, 0.0, 1.0)};
    private static final IParticleRenderType renderType = new IParticleRenderType(){

        public void func_217600_a(BufferBuilder builder, TextureManager textureManager) {
            RenderSystem.disableTexture();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.enableLighting();
            RenderSystem.enableColorMaterial();
            builder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        }

        public void func_217599_a(Tessellator tessellator) {
            tessellator.func_78381_a();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableLighting();
            RenderSystem.enableTexture();
        }
    };
    protected float scale;
    protected boolean hot;
    private boolean billowing = false;

    public CubeParticle(ClientWorld world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z);
        this.field_187129_i = motionX;
        this.field_187130_j = motionY;
        this.field_187131_k = motionZ;
        this.setScale(0.2f);
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.func_187115_a(scale * 0.5f, scale * 0.5f);
    }

    public void averageAge(int age) {
        this.field_70547_e = (int)((double)age + (this.field_187136_p.nextDouble() * 2.0 - 1.0) * 8.0);
    }

    public void setHot(boolean hot) {
        this.hot = hot;
    }

    public void func_189213_a() {
        if (this.hot && this.field_70546_d > 0) {
            if (this.field_187124_d == this.field_187127_g) {
                this.billowing = true;
                this.field_228343_B_ = false;
                if (this.field_187129_i == 0.0 && this.field_187131_k == 0.0) {
                    Vector3d diff = Vector3d.func_237491_b_((Vector3i)new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h)).func_72441_c(0.5, 0.5, 0.5).func_178786_a(this.field_187126_f, this.field_187127_g, this.field_187128_h);
                    this.field_187129_i = -diff.field_72450_a * 0.1;
                    this.field_187131_k = -diff.field_72449_c * 0.1;
                }
                this.field_187129_i *= 1.1;
                this.field_187130_j *= 0.9;
                this.field_187131_k *= 1.1;
            } else if (this.billowing) {
                this.field_187130_j *= 1.2;
            }
        }
        super.func_189213_a();
    }

    public void func_225606_a_(IVertexBuilder builder, ActiveRenderInfo renderInfo, float p_225606_3_) {
        Vector3d projectedView = renderInfo.func_216785_c();
        float lerpedX = (float)(MathHelper.func_219803_d((double)p_225606_3_, (double)this.field_187123_c, (double)this.field_187126_f) - projectedView.func_82615_a());
        float lerpedY = (float)(MathHelper.func_219803_d((double)p_225606_3_, (double)this.field_187124_d, (double)this.field_187127_g) - projectedView.func_82617_b());
        float lerpedZ = (float)(MathHelper.func_219803_d((double)p_225606_3_, (double)this.field_187125_e, (double)this.field_187128_h) - projectedView.func_82616_c());
        int light = 0xF000F0;
        double ageMultiplier = 1.0 - Math.pow(this.field_70546_d, 3.0) / Math.pow(this.field_70547_e, 3.0);
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 4; ++j) {
                Vector3d vec = CUBE[i * 4 + j];
                vec = vec.func_186678_a((double)this.scale * ageMultiplier).func_72441_c((double)lerpedX, (double)lerpedY, (double)lerpedZ);
                Vector3d normal = CUBE_NORMALS[i];
                builder.func_225582_a_(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_225583_a_(0.0f, 0.0f).func_227886_a_(light).func_225584_a_((float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c).func_181675_d();
            }
        }
    }

    public IParticleRenderType func_217558_b() {
        return renderType;
    }

    public static class Factory
    implements IParticleFactory<CubeParticleData> {
        public Particle makeParticle(CubeParticleData data, ClientWorld world, double x, double y, double z, double motionX, double motionY, double motionZ) {
            CubeParticle particle = new CubeParticle(world, x, y, z, motionX, motionY, motionZ);
            particle.func_70538_b(data.r, data.g, data.b);
            particle.setScale(data.scale);
            particle.averageAge(data.avgAge);
            particle.setHot(data.hot);
            return particle;
        }
    }
}

