/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing.burner;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerTileEntity;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;

public class BlazeBurnerRenderer
extends SafeTileEntityRenderer<BlazeBurnerTileEntity> {
    public BlazeBurnerRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(BlazeBurnerTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        BlazeBurnerBlock.HeatLevel heatLevel = te.getHeatLevelFromBlock();
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        float renderTick = AnimationTickHolder.getRenderTime((IWorld)te.func_145831_w()) + (float)(((Object)((Object)te)).hashCode() % 13) * 16.0f;
        float offset = (MathHelper.func_76126_a((float)((float)((double)(renderTick / 16.0f) % (Math.PI * 2)))) + 0.5f) / 16.0f;
        AllBlockPartials blazeModel = AllBlockPartials.BLAZES.get((Object)heatLevel);
        SuperByteBuffer blazeBuffer = blazeModel.renderOn(te.func_195044_w());
        blazeBuffer.rotateCentered(Direction.UP, AngleHelper.rad(te.headAngle.getValue(partialTicks)));
        blazeBuffer.translate(0.0f, offset, 0.0f);
        blazeBuffer.light(0xF000F0).renderInto(ms, buffer.getBuffer(RenderType.func_228639_c_()));
    }
}

