/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.advanced;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryCarriageBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryCarriageTileEntity;
import com.simibubi.create.content.contraptions.relays.advanced.GantryShaftBlock;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;

public class GantryShaftTileEntity
extends KineticTileEntity {
    public GantryShaftTileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        if (!this.canAssembleOn()) {
            return;
        }
        for (Direction d : Iterate.directions) {
            TileEntity tileEntity;
            BlockPos offset;
            BlockState pinionState;
            if (d.func_176740_k() == ((Direction)this.func_195044_w().func_177229_b((Property)GantryShaftBlock.FACING)).func_176740_k() || !AllBlocks.GANTRY_CARRIAGE.has(pinionState = this.field_145850_b.func_180495_p(offset = this.field_174879_c.func_177972_a(d))) || pinionState.func_177229_b((Property)GantryCarriageBlock.FACING) != d || !((tileEntity = this.field_145850_b.func_175625_s(offset)) instanceof GantryCarriageTileEntity)) continue;
            ((GantryCarriageTileEntity)tileEntity).queueAssembly();
        }
    }

    @Override
    public float propagateRotationTo(KineticTileEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        float defaultModifier = super.propagateRotationTo(target, stateFrom, stateTo, diff, connectedViaAxes, connectedViaCogs);
        if (connectedViaAxes) {
            return defaultModifier;
        }
        if (!((Boolean)stateFrom.func_177229_b((Property)GantryShaftBlock.POWERED)).booleanValue()) {
            return defaultModifier;
        }
        if (!AllBlocks.GANTRY_CARRIAGE.has(stateTo)) {
            return defaultModifier;
        }
        Direction direction = Direction.func_176737_a((float)diff.func_177958_n(), (float)diff.func_177956_o(), (float)diff.func_177952_p());
        if (stateTo.func_177229_b((Property)GantryCarriageBlock.FACING) != direction) {
            return defaultModifier;
        }
        return GantryCarriageTileEntity.getGantryPinionModifier((Direction)stateFrom.func_177229_b((Property)GantryShaftBlock.FACING), (Direction)stateTo.func_177229_b((Property)GantryCarriageBlock.FACING));
    }

    @Override
    public boolean isCustomConnection(KineticTileEntity other, BlockState state, BlockState otherState) {
        if (!AllBlocks.GANTRY_CARRIAGE.has(otherState)) {
            return false;
        }
        BlockPos diff = other.func_174877_v().func_177973_b((Vector3i)this.field_174879_c);
        Direction direction = Direction.func_176737_a((float)diff.func_177958_n(), (float)diff.func_177956_o(), (float)diff.func_177952_p());
        return otherState.func_177229_b((Property)GantryCarriageBlock.FACING) == direction;
    }

    public boolean canAssembleOn() {
        BlockState blockState = this.func_195044_w();
        if (!AllBlocks.GANTRY_SHAFT.has(blockState)) {
            return false;
        }
        if (((Boolean)blockState.func_177229_b((Property)GantryShaftBlock.POWERED)).booleanValue()) {
            return false;
        }
        float speed = this.getPinionMovementSpeed();
        switch ((GantryShaftBlock.Part)((Object)blockState.func_177229_b(GantryShaftBlock.PART))) {
            case END: {
                return speed < 0.0f;
            }
            case MIDDLE: {
                return speed != 0.0f;
            }
            case START: {
                return speed > 0.0f;
            }
        }
        return false;
    }

    public float getPinionMovementSpeed() {
        BlockState blockState = this.func_195044_w();
        if (!AllBlocks.GANTRY_SHAFT.has(blockState)) {
            return 0.0f;
        }
        return MathHelper.func_76131_a((float)(-this.getSpeed() / 512.0f), (float)-0.49f, (float)0.49f);
    }
}

