/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.belt.transport;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltPart;
import com.simibubi.create.content.contraptions.relays.belt.BeltSlope;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class BeltMovementHandler {
    public static boolean canBeTransported(Entity entity) {
        if (!entity.func_70089_S()) {
            return false;
        }
        return !(entity instanceof PlayerEntity) || !((PlayerEntity)entity).func_225608_bj_();
    }

    public static void transportEntity(BeltTileEntity beltTe, Entity entityIn, TransportedEntityInfo info) {
        boolean movedPastEndingSlope;
        boolean movingUp;
        boolean movingDown;
        boolean onSlope;
        double diffCenter;
        boolean notHorizontal;
        boolean betweenBelts;
        BlockPos pos = info.lastCollidedPos;
        World world = beltTe.func_145831_w();
        TileEntity te = world.func_175625_s(pos);
        TileEntity tileEntityBelowPassenger = world.func_175625_s(entityIn.func_233580_cy_());
        BlockState blockState = info.lastCollidedState;
        Direction movementFacing = Direction.func_211699_a((Direction.Axis)((Direction)blockState.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176740_k(), (Direction.AxisDirection)(beltTe.getSpeed() < 0.0f ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE));
        boolean collidedWithBelt = te instanceof BeltTileEntity;
        boolean bl = betweenBelts = tileEntityBelowPassenger instanceof BeltTileEntity && tileEntityBelowPassenger != te;
        if (!collidedWithBelt || betweenBelts) {
            return;
        }
        boolean bl2 = notHorizontal = beltTe.func_195044_w().func_177229_b(BeltBlock.SLOPE) != BeltSlope.HORIZONTAL;
        if (Math.abs(beltTe.getSpeed()) < 1.0f) {
            return;
        }
        if (entityIn.func_226278_cu_() - 0.25 < (double)pos.func_177956_o()) {
            return;
        }
        boolean isPlayer = entityIn instanceof PlayerEntity;
        if (entityIn instanceof LivingEntity && !isPlayer) {
            ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76421_d, 10, 1, false, false));
        }
        Direction beltFacing = (Direction)blockState.func_177229_b((Property)BlockStateProperties.field_208157_J);
        BeltSlope slope = (BeltSlope)((Object)blockState.func_177229_b(BeltBlock.SLOPE));
        Direction.Axis axis = beltFacing.func_176740_k();
        float movementSpeed = beltTe.getBeltMovementSpeed();
        Direction movementDirection = Direction.func_181076_a((Direction.AxisDirection)(axis == Direction.Axis.X ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE), (Direction.Axis)axis);
        Vector3i centeringDirection = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)beltFacing.func_176746_e().func_176740_k()).func_176730_m();
        Vector3d movement = Vector3d.func_237491_b_((Vector3i)movementDirection.func_176730_m()).func_186678_a((double)movementSpeed);
        double d = diffCenter = axis == Direction.Axis.Z ? (double)((float)pos.func_177958_n() + 0.5f) - entityIn.func_226277_ct_() : (double)((float)pos.func_177952_p() + 0.5f) - entityIn.func_226281_cx_();
        if (Math.abs(diffCenter) > 0.75) {
            return;
        }
        BeltPart part = (BeltPart)((Object)blockState.func_177229_b(BeltBlock.PART));
        float top = 0.8125f;
        boolean bl3 = notHorizontal && (part == BeltPart.MIDDLE || part == BeltPart.PULLEY || part == (slope == BeltSlope.UPWARD ? BeltPart.END : BeltPart.START) && entityIn.func_226278_cu_() - (double)pos.func_177956_o() < (double)top || part == (slope == BeltSlope.UPWARD ? BeltPart.START : BeltPart.END) && entityIn.func_226278_cu_() - (double)pos.func_177956_o() > (double)top) ? true : (onSlope = false);
        boolean bl4 = onSlope && slope == (movementFacing == beltFacing ? BeltSlope.DOWNWARD : BeltSlope.UPWARD) ? true : (movingDown = false);
        boolean bl5 = onSlope && slope == (movementFacing == beltFacing ? BeltSlope.UPWARD : BeltSlope.DOWNWARD) ? true : (movingUp = false);
        if (beltFacing.func_176740_k() == Direction.Axis.Z) {
            boolean b = movingDown;
            movingDown = movingUp;
            movingUp = b;
        }
        if (movingUp) {
            movement = movement.func_72441_c(0.0, Math.abs(axis.func_196051_a(movement.field_72450_a, movement.field_72448_b, movement.field_72449_c)), 0.0);
        }
        if (movingDown) {
            movement = movement.func_72441_c(0.0, -Math.abs(axis.func_196051_a(movement.field_72450_a, movement.field_72448_b, movement.field_72449_c)), 0.0);
        }
        Vector3d centering = Vector3d.func_237491_b_((Vector3i)centeringDirection).func_186678_a(diffCenter * (double)Math.min(Math.abs(movementSpeed), 0.1f) * 4.0);
        float step = entityIn.field_70138_W;
        if (!isPlayer) {
            movement = movement.func_178787_e(centering);
            entityIn.field_70138_W = 1.0f;
        }
        if (Math.abs(movementSpeed) < 0.5f) {
            Vector3d checkDistance = movement.func_72432_b().func_186678_a(0.5);
            AxisAlignedBB bb = entityIn.func_174813_aQ();
            AxisAlignedBB checkBB = new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
            checkBB = checkBB.func_191194_a(checkDistance).func_72314_b(-Math.abs(checkDistance.field_72450_a), -Math.abs(checkDistance.field_72448_b), -Math.abs(checkDistance.field_72449_c));
            List list = world.func_72839_b(entityIn, checkBB);
            list.removeIf(e -> BeltMovementHandler.shouldIgnoreBlocking(entityIn, e));
            if (!list.isEmpty()) {
                entityIn.func_213293_j(0.0, 0.0, 0.0);
                --info.ticksSinceLastCollision;
                return;
            }
        }
        entityIn.field_70143_R = 0.0f;
        if (movingUp) {
            float minVelocity = 0.13f;
            float yMovement = (float)(-Math.max(Math.abs(movement.field_72448_b), (double)minVelocity));
            entityIn.func_213315_a(MoverType.SELF, new Vector3d(0.0, (double)yMovement, 0.0));
            entityIn.func_213315_a(MoverType.SELF, movement.func_216372_d(1.0, 0.0, 1.0));
        } else if (movingDown) {
            entityIn.func_213315_a(MoverType.SELF, movement.func_216372_d(1.0, 0.0, 1.0));
            entityIn.func_213315_a(MoverType.SELF, movement.func_216372_d(0.0, 1.0, 0.0));
        } else {
            entityIn.func_213315_a(MoverType.SELF, movement);
        }
        if (!isPlayer) {
            entityIn.field_70138_W = step;
        }
        boolean bl6 = movedPastEndingSlope = onSlope && (AllBlocks.BELT.has(world.func_180495_p(entityIn.func_233580_cy_())) || AllBlocks.BELT.has(world.func_180495_p(entityIn.func_233580_cy_().func_177977_b())));
        if (movedPastEndingSlope && !movingDown && Math.abs(movementSpeed) > 0.0f) {
            entityIn.func_70107_b(entityIn.func_226277_ct_(), entityIn.func_226278_cu_() + movement.field_72448_b, entityIn.func_226281_cx_());
        }
        if (movedPastEndingSlope) {
            entityIn.func_213317_d(movement);
            entityIn.field_70133_I = true;
        }
    }

    public static boolean shouldIgnoreBlocking(Entity me, Entity other) {
        if (other instanceof AbstractContraptionEntity) {
            return true;
        }
        if (other instanceof HangingEntity) {
            return true;
        }
        return BeltMovementHandler.isRidingOrBeingRiddenBy(me, other);
    }

    public static boolean isRidingOrBeingRiddenBy(Entity me, Entity other) {
        for (Entity entity : me.func_184188_bt()) {
            if (entity.equals((Object)other)) {
                return true;
            }
            if (!BeltMovementHandler.isRidingOrBeingRiddenBy(entity, other)) continue;
            return true;
        }
        return false;
    }

    public static class TransportedEntityInfo {
        int ticksSinceLastCollision;
        BlockPos lastCollidedPos;
        BlockState lastCollidedState;

        public TransportedEntityInfo(BlockPos collision, BlockState belt) {
            this.refresh(collision, belt);
        }

        public void refresh(BlockPos collision, BlockState belt) {
            this.ticksSinceLastCollision = 0;
            this.lastCollidedPos = new BlockPos((Vector3i)collision).func_185334_h();
            this.lastCollidedState = belt;
        }

        public TransportedEntityInfo tick() {
            ++this.ticksSinceLastCollision;
            return this;
        }

        public int getTicksSinceLastCollision() {
            return this.ticksSinceLastCollision;
        }
    }
}

