/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.zapper.blockzapper;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.content.curiosities.zapper.ZapperItemRenderer;
import com.simibubi.create.content.curiosities.zapper.blockzapper.BlockzapperItem;
import com.simibubi.create.content.curiosities.zapper.blockzapper.BlockzapperModel;
import com.simibubi.create.foundation.item.PartialItemModelRenderer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;

public class BlockzapperItemRenderer
extends ZapperItemRenderer<BlockzapperModel> {
    @Override
    protected void render(ItemStack stack, BlockzapperModel model, PartialItemModelRenderer renderer, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        super.render(stack, model, renderer, ms, buffer, light, overlay);
        float pt = AnimationTickHolder.getPartialTicks();
        float worldTime = AnimationTickHolder.getRenderTime() / 20.0f;
        renderer.render(model.getBakedModel(), light);
        this.renderComponent(stack, model, BlockzapperItem.Components.Body, renderer, light);
        this.renderComponent(stack, model, BlockzapperItem.Components.Amplifier, renderer, light);
        this.renderComponent(stack, model, BlockzapperItem.Components.Retriever, renderer, light);
        this.renderComponent(stack, model, BlockzapperItem.Components.Scope, renderer, light);
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        boolean leftHanded = player.func_184591_cq() == HandSide.LEFT;
        boolean mainHand = player.func_184614_ca() == stack;
        boolean offHand = player.func_184592_cb() == stack;
        float animation = this.getAnimationProgress(pt, leftHanded, mainHand);
        float multiplier = MathHelper.func_76126_a((float)(worldTime * 5.0f));
        if (mainHand || offHand) {
            multiplier = animation;
        }
        int lightItensity = (int)(15.0f * MathHelper.func_76131_a((float)multiplier, (float)0.0f, (float)1.0f));
        int glowLight = LightTexture.func_228451_a_((int)lightItensity, (int)Math.max(lightItensity, 4));
        renderer.renderSolidGlowing(model.getPartial("core"), glowLight);
        renderer.renderGlowing(model.getPartial("core_glow"), glowLight);
        if (BlockzapperItem.getTier(BlockzapperItem.Components.Amplifier, stack) != BlockzapperItem.ComponentTier.None) {
            renderer.renderSolidGlowing(model.getPartial("amplifier_core"), glowLight);
            renderer.renderGlowing(model.getPartial("amplifier_core_glow"), glowLight);
        }
        float angle = worldTime * -25.0f;
        if (mainHand || offHand) {
            angle += 360.0f * animation;
        }
        float offset = -0.155f;
        ms.func_227861_a_(0.0, (double)offset, 0.0);
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(angle %= 360.0f));
        ms.func_227861_a_(0.0, (double)(-offset), 0.0);
        this.renderComponent(stack, model, BlockzapperItem.Components.Accelerator, renderer, light);
    }

    public void renderComponent(ItemStack stack, BlockzapperModel model, BlockzapperItem.Components component, PartialItemModelRenderer renderer, int light) {
        BlockzapperItem.ComponentTier tier = BlockzapperItem.getTier(component, stack);
        IBakedModel partial = model.getComponentPartial(tier, component);
        if (partial != null) {
            renderer.render(partial, light);
        }
    }
}

