/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block;

import com.simibubi.create.foundation.render.backend.core.IFlatLight;
import com.simibubi.create.foundation.render.backend.instancing.InstanceData;
import com.simibubi.create.foundation.render.backend.instancing.InstancedModel;
import java.nio.ByteBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;

public class FlapData
extends InstanceData
implements IFlatLight<FlapData> {
    private float x;
    private float y;
    private float z;
    private byte blockLight;
    private byte skyLight;
    private float segmentOffsetX;
    private float segmentOffsetY;
    private float segmentOffsetZ;
    private float pivotX;
    private float pivotY;
    private float pivotZ;
    private float horizontalAngle;
    private float intensity;
    private float flapScale;
    private float flapness;

    public FlapData(InstancedModel<?> owner) {
        super(owner);
    }

    public FlapData setPosition(BlockPos pos) {
        return this.setPosition(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public FlapData setPosition(Vector3f pos) {
        return this.setPosition(pos.func_195899_a(), pos.func_195900_b(), pos.func_195902_c());
    }

    public FlapData setPosition(int x, int y, int z) {
        BlockPos origin = this.owner.renderer.getOriginCoordinate();
        return this.setPosition((float)(x - origin.func_177958_n()), (float)(y - origin.func_177956_o()), (float)(z - origin.func_177952_p()));
    }

    public FlapData setPosition(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.markDirty();
        return this;
    }

    @Override
    public FlapData setBlockLight(int blockLight) {
        this.blockLight = (byte)((blockLight & 0xF) << 4);
        this.markDirty();
        return this;
    }

    @Override
    public FlapData setSkyLight(int skyLight) {
        this.skyLight = (byte)((skyLight & 0xF) << 4);
        this.markDirty();
        return this;
    }

    public FlapData setSegmentOffset(float x, float y, float z) {
        this.segmentOffsetX = x;
        this.segmentOffsetY = y;
        this.segmentOffsetZ = z;
        this.markDirty();
        return this;
    }

    public FlapData setIntensity(float intensity) {
        this.intensity = intensity;
        this.markDirty();
        return this;
    }

    public FlapData setHorizontalAngle(float horizontalAngle) {
        this.horizontalAngle = horizontalAngle;
        this.markDirty();
        return this;
    }

    public FlapData setFlapScale(float flapScale) {
        this.flapScale = flapScale;
        this.markDirty();
        return this;
    }

    public FlapData setFlapness(float flapness) {
        this.flapness = flapness;
        this.markDirty();
        return this;
    }

    public FlapData setPivotVoxelSpace(float x, float y, float z) {
        this.pivotX = x / 16.0f;
        this.pivotY = y / 16.0f;
        this.pivotZ = z / 16.0f;
        this.markDirty();
        return this;
    }

    @Override
    public void write(ByteBuffer buf) {
        this.putVec3(buf, this.x, this.y, this.z);
        this.putVec2(buf, this.blockLight, this.skyLight);
        this.putVec3(buf, this.segmentOffsetX, this.segmentOffsetY, this.segmentOffsetZ);
        this.putVec3(buf, this.pivotX, this.pivotY, this.pivotZ);
        this.put(buf, this.horizontalAngle);
        this.put(buf, this.intensity);
        this.put(buf, this.flapScale);
        this.put(buf, this.flapness);
    }
}

