/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.depot;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.relays.encased.ShaftInstance;
import com.simibubi.create.content.logistics.block.depot.EjectorRenderer;
import com.simibubi.create.content.logistics.block.depot.EjectorTileEntity;
import com.simibubi.create.foundation.render.backend.core.ModelData;
import com.simibubi.create.foundation.render.backend.instancing.IDynamicInstance;
import com.simibubi.create.foundation.render.backend.instancing.InstancedTileRenderer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.MatrixStacker;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;

public class EjectorInstance
extends ShaftInstance
implements IDynamicInstance {
    protected final EjectorTileEntity tile;
    protected final ModelData plate;
    private float lastProgress = Float.NaN;

    public EjectorInstance(InstancedTileRenderer<?> dispatcher, EjectorTileEntity tile) {
        super(dispatcher, tile);
        this.tile = tile;
        this.plate = this.getTransformMaterial().getModel(AllBlockPartials.EJECTOR_TOP, this.blockState).createInstance();
        this.pivotPlate();
    }

    @Override
    public void beginFrame() {
        float lidProgress = this.getLidProgress();
        if (MathHelper.func_180185_a((float)lidProgress, (float)this.lastProgress)) {
            return;
        }
        this.pivotPlate(lidProgress);
        this.lastProgress = lidProgress;
    }

    @Override
    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, this.plate);
    }

    @Override
    public void remove() {
        super.remove();
        this.plate.delete();
    }

    private void pivotPlate() {
        this.pivotPlate(this.getLidProgress());
    }

    private float getLidProgress() {
        return this.tile.getLidProgress(AnimationTickHolder.getPartialTicks());
    }

    private void pivotPlate(float lidProgress) {
        float angle = lidProgress * 70.0f;
        MatrixStack ms = new MatrixStack();
        EjectorRenderer.applyLidAngle(this.tile, angle, MatrixStacker.of(ms).translate((Vector3i)this.getInstancePosition()));
        this.plate.setTransform(ms);
    }
}

