/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.depot;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.block.depot.DepotBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class SharedDepotBlockMethods {
    protected static DepotBehaviour get(IBlockReader worldIn, BlockPos pos) {
        return TileEntityBehaviour.get(worldIn, pos, DepotBehaviour.TYPE);
    }

    public static ActionResultType onUse(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        if (ray.func_216354_b() != Direction.UP) {
            return ActionResultType.PASS;
        }
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        DepotBehaviour behaviour = SharedDepotBlockMethods.get((IBlockReader)world, pos);
        if (behaviour == null) {
            return ActionResultType.PASS;
        }
        if (!behaviour.canAcceptItems.get().booleanValue()) {
            return ActionResultType.SUCCESS;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        boolean wasEmptyHanded = heldItem.func_190926_b();
        boolean shouldntPlaceItem = AllBlocks.MECHANICAL_ARM.isIn(heldItem);
        ItemStack mainItemStack = behaviour.getHeldItemStack();
        if (!mainItemStack.func_190926_b()) {
            player.field_71071_by.func_191975_a(world, mainItemStack);
            behaviour.removeHeldItem();
        }
        ItemStackHandler outputs = behaviour.processingOutputBuffer;
        for (int i = 0; i < outputs.getSlots(); ++i) {
            player.field_71071_by.func_191975_a(world, outputs.extractItem(i, 64, false));
        }
        if (!wasEmptyHanded && !shouldntPlaceItem) {
            TransportedItemStack transported = new TransportedItemStack(heldItem);
            transported.insertedFrom = player.func_174811_aO();
            transported.prevBeltPosition = 0.25f;
            transported.beltPosition = 0.25f;
            behaviour.setHeldItem(transported);
            player.func_184611_a(hand, ItemStack.field_190927_a);
        }
        behaviour.tileEntity.notifyUpdate();
        return ActionResultType.SUCCESS;
    }

    public static void onReplaced(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.hasTileEntity() || state.func_177230_c() == newState.func_177230_c()) {
            return;
        }
        DepotBehaviour behaviour = SharedDepotBlockMethods.get((IBlockReader)worldIn, pos);
        if (behaviour == null) {
            return;
        }
        ItemHelper.dropContents(worldIn, pos, (IItemHandler)behaviour.processingOutputBuffer);
        for (TransportedItemStack transportedItemStack : behaviour.incoming) {
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)transportedItemStack.stack);
        }
        if (!behaviour.getHeldItemStack().func_190926_b()) {
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)behaviour.getHeldItemStack());
        }
        worldIn.func_175713_t(pos);
    }

    public static void onLanded(IBlockReader worldIn, Entity entityIn) {
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        if (!entityIn.func_70089_S()) {
            return;
        }
        if (entityIn.field_70170_p.field_72995_K) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entityIn;
        DirectBeltInputBehaviour inputBehaviour = TileEntityBehaviour.get(worldIn, entityIn.func_233580_cy_(), DirectBeltInputBehaviour.TYPE);
        if (inputBehaviour == null) {
            return;
        }
        ItemStack remainder = inputBehaviour.handleInsertion(itemEntity.func_92059_d(), Direction.DOWN, false);
        itemEntity.func_92058_a(remainder);
        if (remainder.func_190926_b()) {
            itemEntity.func_70106_y();
        }
    }

    public static int getComparatorInputOverride(BlockState blockState, World worldIn, BlockPos pos) {
        DepotBehaviour depotBehaviour = SharedDepotBlockMethods.get((IBlockReader)worldIn, pos);
        if (depotBehaviour == null) {
            return 0;
        }
        return ItemHelper.calcRedstoneFromInventory(depotBehaviour.itemHandler);
    }
}

