/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.funnel;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.block.funnel.AbstractFunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.BeltFunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelFilterSlotPositioning;
import com.simibubi.create.content.logistics.block.redstone.ContentObserverBlock;
import com.simibubi.create.content.logistics.packet.FunnelFlapPacket;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.gui.widgets.InterpolatedChasingValue;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.render.backend.FastRenderDispatcher;
import com.simibubi.create.foundation.render.backend.instancing.IInstanceRendered;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.utility.BlockFace;
import com.simibubi.create.foundation.utility.VecHelper;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class FunnelTileEntity
extends SmartTileEntity
implements IHaveHoveringInformation,
IInstanceRendered {
    private FilteringBehaviour filtering;
    private InvManipulationBehaviour invManipulation;
    private int extractionCooldown = 0;
    private WeakReference<ItemEntity> lastObserved;
    InterpolatedChasingValue flap = new InterpolatedChasingValue().start(0.25f).target(0.0f).withSpeed(0.05f);
    static final AxisAlignedBB coreBB = new AxisAlignedBB(VecHelper.CENTER_OF_ORIGIN, VecHelper.CENTER_OF_ORIGIN).func_186662_g(0.75);

    public FunnelTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public Mode determineCurrentMode() {
        BlockState state = this.func_195044_w();
        if (!FunnelBlock.isFunnel(state)) {
            return Mode.INVALID;
        }
        if (state.func_235903_d_((Property)BlockStateProperties.field_208194_u).orElse(false).booleanValue()) {
            return Mode.PAUSED;
        }
        if (state.func_177230_c() instanceof BeltFunnelBlock) {
            BeltFunnelBlock.Shape shape = (BeltFunnelBlock.Shape)((Object)state.func_177229_b(BeltFunnelBlock.SHAPE));
            if (shape == BeltFunnelBlock.Shape.PULLING) {
                return Mode.TAKING_FROM_BELT;
            }
            if (shape == BeltFunnelBlock.Shape.PUSHING) {
                return Mode.PUSHING_TO_BELT;
            }
            BeltTileEntity belt = BeltHelper.getSegmentTE((IWorld)this.field_145850_b, this.field_174879_c.func_177977_b());
            if (belt != null) {
                return belt.getMovementFacing() == state.func_177229_b((Property)BeltFunnelBlock.HORIZONTAL_FACING) ? Mode.PUSHING_TO_BELT : Mode.TAKING_FROM_BELT;
            }
            return Mode.INVALID;
        }
        if (state.func_177230_c() instanceof FunnelBlock) {
            return (Boolean)state.func_177229_b((Property)FunnelBlock.EXTRACTING) != false ? Mode.EXTRACT : Mode.COLLECT;
        }
        return Mode.INVALID;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.flap.tick();
        Mode mode = this.determineCurrentMode();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (mode == Mode.PAUSED) {
            this.extractionCooldown = 0;
        }
        if (mode == Mode.TAKING_FROM_BELT) {
            return;
        }
        if (this.extractionCooldown > 0) {
            --this.extractionCooldown;
            return;
        }
        if (mode == Mode.PUSHING_TO_BELT) {
            this.activateExtractingBeltFunnel();
        }
        if (mode == Mode.EXTRACT) {
            this.activateExtractor();
        }
    }

    private void activateExtractor() {
        BlockState blockState = this.func_195044_w();
        Direction facing = AbstractFunnelBlock.getFunnelFacing(blockState);
        if (facing == null) {
            return;
        }
        boolean trackingEntityPresent = true;
        AxisAlignedBB area = this.getEntityOverflowScanningArea();
        if (this.lastObserved == null) {
            trackingEntityPresent = false;
        } else {
            ItemEntity lastEntity = (ItemEntity)this.lastObserved.get();
            if (lastEntity == null || !lastEntity.func_70089_S() || !lastEntity.func_174813_aQ().func_72326_a(area)) {
                trackingEntityPresent = false;
                this.lastObserved = null;
            }
        }
        if (trackingEntityPresent) {
            return;
        }
        int amountToExtract = this.getAmountToExtract();
        ItemStack stack = this.invManipulation.simulate().extract(amountToExtract);
        if (stack.func_190926_b()) {
            return;
        }
        Iterator iterator = this.field_145850_b.func_217357_a(ItemEntity.class, area).iterator();
        if (iterator.hasNext()) {
            ItemEntity itemEntity = (ItemEntity)iterator.next();
            this.lastObserved = new WeakReference<ItemEntity>(itemEntity);
            return;
        }
        stack = this.invManipulation.extract(amountToExtract);
        if (stack.func_190926_b()) {
            return;
        }
        this.flap(false);
        this.onTransfer(stack);
        Vector3d outputPos = VecHelper.getCenterOf((Vector3i)this.field_174879_c);
        boolean vertical = facing.func_176740_k().func_200128_b();
        boolean up = facing == Direction.UP;
        outputPos = outputPos.func_178787_e(Vector3d.func_237491_b_((Vector3i)facing.func_176730_m()).func_186678_a(vertical ? (up ? (double)0.15f : 0.5) : 0.25));
        if (!vertical) {
            outputPos = outputPos.func_178786_a(0.0, (double)0.45f, 0.0);
        }
        Vector3d motion = Vector3d.field_186680_a;
        if (up) {
            motion = new Vector3d(0.0, 0.25, 0.0);
        }
        ItemEntity item = new ItemEntity(this.field_145850_b, outputPos.field_72450_a, outputPos.field_72448_b, outputPos.field_72449_c, stack.func_77946_l());
        item.func_174869_p();
        item.func_213317_d(motion);
        this.field_145850_b.func_217376_c((Entity)item);
        this.lastObserved = new WeakReference<ItemEntity>(item);
        this.startCooldown();
    }

    private AxisAlignedBB getEntityOverflowScanningArea() {
        Direction facing = AbstractFunnelBlock.getFunnelFacing(this.func_195044_w());
        AxisAlignedBB bb = coreBB.func_186670_a(this.field_174879_c);
        if (facing == null || facing == Direction.UP) {
            return bb;
        }
        return bb.func_72321_a(0.0, -1.0, 0.0);
    }

    private void activateExtractingBeltFunnel() {
        BlockState blockState = this.func_195044_w();
        Direction facing = (Direction)blockState.func_177229_b((Property)BeltFunnelBlock.HORIZONTAL_FACING);
        DirectBeltInputBehaviour inputBehaviour = TileEntityBehaviour.get((IBlockReader)this.field_145850_b, this.field_174879_c.func_177977_b(), DirectBeltInputBehaviour.TYPE);
        if (inputBehaviour == null) {
            return;
        }
        if (!inputBehaviour.canInsertFromSide(facing)) {
            return;
        }
        int amountToExtract = this.getAmountToExtract();
        ItemStack stack = this.invManipulation.extract(amountToExtract, s -> inputBehaviour.handleInsertion((ItemStack)s, facing, true).func_190926_b());
        if (stack.func_190926_b()) {
            return;
        }
        this.flap(false);
        this.onTransfer(stack);
        inputBehaviour.handleInsertion(stack, facing, false);
        this.startCooldown();
    }

    public int getAmountToExtract() {
        if (!this.supportsAmountOnFilter()) {
            return -1;
        }
        int amountToExtract = this.invManipulation.getAmountFromFilter();
        if (!this.filtering.isActive()) {
            amountToExtract = 1;
        }
        return amountToExtract;
    }

    private int startCooldown() {
        this.extractionCooldown = (Integer)AllConfigs.SERVER.logistics.defaultExtractionTimer.get();
        return this.extractionCooldown;
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        this.invManipulation = new InvManipulationBehaviour(this, (w, p, s) -> new BlockFace(p, AbstractFunnelBlock.getFunnelFacing(s).func_176734_d()));
        behaviours.add(this.invManipulation);
        this.filtering = new FilteringBehaviour(this, new FunnelFilterSlotPositioning());
        this.filtering.showCountWhen(this::supportsAmountOnFilter);
        this.filtering.onlyActiveWhen(this::supportsFiltering);
        behaviours.add(this.filtering);
        behaviours.add(new DirectBeltInputBehaviour(this).onlyInsertWhen(this::supportsDirectBeltInput).setInsertionHandler(this::handleDirectBeltInput));
    }

    private boolean supportsAmountOnFilter() {
        BlockState blockState = this.func_195044_w();
        boolean beltFunnelsupportsAmount = false;
        if (blockState.func_177230_c() instanceof BeltFunnelBlock) {
            BeltFunnelBlock.Shape shape = (BeltFunnelBlock.Shape)((Object)blockState.func_177229_b(BeltFunnelBlock.SHAPE));
            beltFunnelsupportsAmount = shape == BeltFunnelBlock.Shape.PUSHING ? true : BeltHelper.getSegmentTE((IWorld)this.field_145850_b, this.field_174879_c.func_177977_b()) != null;
        }
        boolean extractor = blockState.func_177230_c() instanceof FunnelBlock && (Boolean)blockState.func_177229_b((Property)FunnelBlock.EXTRACTING) != false;
        return beltFunnelsupportsAmount || extractor;
    }

    private boolean supportsDirectBeltInput(Direction side) {
        BlockState blockState = this.func_195044_w();
        if (blockState == null) {
            return false;
        }
        if (!(blockState.func_177230_c() instanceof FunnelBlock)) {
            return false;
        }
        if (((Boolean)blockState.func_177229_b((Property)FunnelBlock.EXTRACTING)).booleanValue()) {
            return false;
        }
        return FunnelBlock.getFunnelFacing(blockState) == Direction.UP;
    }

    private boolean supportsFiltering() {
        BlockState blockState = this.func_195044_w();
        return AllBlocks.BRASS_BELT_FUNNEL.has(blockState) || AllBlocks.BRASS_FUNNEL.has(blockState);
    }

    private ItemStack handleDirectBeltInput(TransportedItemStack stack, Direction side, boolean simulate) {
        ItemStack inserted = stack.stack;
        if (!this.filtering.test(inserted)) {
            return inserted;
        }
        if (this.determineCurrentMode() == Mode.PAUSED) {
            return inserted;
        }
        if (simulate) {
            this.invManipulation.simulate();
        }
        if (!simulate) {
            this.onTransfer(inserted);
        }
        return this.invManipulation.insert(inserted);
    }

    public void flap(boolean inward) {
        if (!this.field_145850_b.field_72995_K) {
            AllPackets.channel.send(this.packetTarget(), (Object)new FunnelFlapPacket(this, inward));
        } else {
            this.flap.set(inward ? 1.0f : -1.0f);
        }
    }

    public boolean hasFlap() {
        BlockState blockState = this.func_195044_w();
        return AbstractFunnelBlock.getFunnelFacing(blockState).func_176740_k().func_176722_c();
    }

    public float getFlapOffset() {
        BlockState blockState = this.func_195044_w();
        if (!(blockState.func_177230_c() instanceof BeltFunnelBlock)) {
            return -0.0625f;
        }
        switch ((BeltFunnelBlock.Shape)((Object)blockState.func_177229_b(BeltFunnelBlock.SHAPE))) {
            default: {
                return 0.0f;
            }
            case EXTENDED: {
                return 0.5f;
            }
            case PULLING: 
            case PUSHING: 
        }
        return -0.125f;
    }

    @Override
    protected void write(CompoundNBT compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.func_74768_a("TransferCooldown", this.extractionCooldown);
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        super.fromTag(state, compound, clientPacket);
        this.extractionCooldown = compound.func_74762_e("TransferCooldown");
        if (clientPacket) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FastRenderDispatcher.enqueueUpdate(this));
        }
    }

    public double func_145833_n() {
        return this.hasFlap() ? super.func_145833_n() : 64.0;
    }

    public void onTransfer(ItemStack stack) {
        ((ContentObserverBlock)AllBlocks.CONTENT_OBSERVER.get()).onFunnelTransfer(this.field_145850_b, this.field_174879_c, stack);
    }

    @Override
    public boolean shouldRenderAsTE() {
        return true;
    }

    static enum Mode {
        INVALID,
        PAUSED,
        COLLECT,
        PUSHING_TO_BELT,
        TAKING_FROM_BELT,
        EXTRACT;

    }
}

