/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter;

import com.simibubi.create.content.logistics.item.filter.AbstractFilterContainer;
import com.simibubi.create.content.logistics.item.filter.AttributeFilterContainer;
import com.simibubi.create.content.logistics.item.filter.FilterContainer;
import com.simibubi.create.content.logistics.item.filter.ItemAttribute;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class FilterScreenPacket
extends SimplePacketBase {
    private final Option option;
    private final CompoundNBT data;

    public FilterScreenPacket(Option option) {
        this(option, new CompoundNBT());
    }

    public FilterScreenPacket(Option option, CompoundNBT data) {
        this.option = option;
        this.data = data;
    }

    public FilterScreenPacket(PacketBuffer buffer) {
        this.option = Option.values()[buffer.readInt()];
        this.data = buffer.func_150793_b();
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.writeInt(this.option.ordinal());
        buffer.func_150786_a(this.data);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            AbstractFilterContainer c;
            ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            if (player.field_71070_bA instanceof AbstractFilterContainer) {
                c = (AbstractFilterContainer)player.field_71070_bA;
                if (this.option == Option.CLEAR) {
                    c.clearContents();
                    return;
                }
            }
            if (player.field_71070_bA instanceof FilterContainer) {
                c = (FilterContainer)player.field_71070_bA;
                if (this.option == Option.WHITELIST) {
                    ((FilterContainer)c).blacklist = false;
                }
                if (this.option == Option.BLACKLIST) {
                    ((FilterContainer)c).blacklist = true;
                }
                if (this.option == Option.RESPECT_DATA) {
                    ((FilterContainer)c).respectNBT = true;
                }
                if (this.option == Option.IGNORE_DATA) {
                    ((FilterContainer)c).respectNBT = false;
                }
                if (this.option == Option.UPDATE_FILTER_ITEM) {
                    ((FilterContainer)c).filterInventory.setStackInSlot(this.data.func_74762_e("Slot"), ItemStack.func_199557_a((CompoundNBT)this.data.func_74775_l("Item")));
                }
            }
            if (player.field_71070_bA instanceof AttributeFilterContainer) {
                c = (AttributeFilterContainer)player.field_71070_bA;
                if (this.option == Option.WHITELIST) {
                    ((AttributeFilterContainer)c).whitelistMode = AttributeFilterContainer.WhitelistMode.WHITELIST_DISJ;
                }
                if (this.option == Option.WHITELIST2) {
                    ((AttributeFilterContainer)c).whitelistMode = AttributeFilterContainer.WhitelistMode.WHITELIST_CONJ;
                }
                if (this.option == Option.BLACKLIST) {
                    ((AttributeFilterContainer)c).whitelistMode = AttributeFilterContainer.WhitelistMode.BLACKLIST;
                }
                if (this.option == Option.ADD_TAG) {
                    ((AttributeFilterContainer)c).appendSelectedAttribute(ItemAttribute.fromNBT(this.data), false);
                }
                if (this.option == Option.ADD_INVERTED_TAG) {
                    ((AttributeFilterContainer)c).appendSelectedAttribute(ItemAttribute.fromNBT(this.data), true);
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public static enum Option {
        CLEAR,
        WHITELIST,
        WHITELIST2,
        BLACKLIST,
        RESPECT_DATA,
        IGNORE_DATA,
        UPDATE_FILTER_ITEM,
        ADD_TAG,
        ADD_INVERTED_TAG;

    }
}

