/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics;

import com.simibubi.create.content.schematics.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.ISpecialEntityItemRequirement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.GrassPathBlock;
import net.minecraft.block.SeaPickleBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.TurtleEggBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.IItemProvider;

public class ItemRequirement {
    ItemUseType usage;
    List<ItemStack> requiredItems;
    public static ItemRequirement INVALID = new ItemRequirement();
    public static ItemRequirement NONE = new ItemRequirement();

    private ItemRequirement() {
    }

    public ItemRequirement(ItemUseType usage, Item item) {
        this(usage, Arrays.asList(new ItemStack((IItemProvider)item)));
    }

    public ItemRequirement(ItemUseType usage, List<ItemStack> requiredItems) {
        this.usage = usage;
        this.requiredItems = requiredItems;
    }

    public static ItemRequirement of(BlockState state) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_150350_a) {
            return NONE;
        }
        if (block instanceof ISpecialBlockItemRequirement) {
            return ((ISpecialBlockItemRequirement)block).getRequiredItems(state);
        }
        Item item = BlockItem.field_179220_a.getOrDefault(state.func_177230_c(), Items.field_190931_a);
        if (state.func_235901_b_((Property)BlockStateProperties.field_208145_at) && state.func_177229_b((Property)BlockStateProperties.field_208145_at) == SlabType.DOUBLE) {
            return new ItemRequirement(ItemUseType.CONSUME, Arrays.asList(new ItemStack((IItemProvider)item, 2)));
        }
        if (block instanceof TurtleEggBlock) {
            return new ItemRequirement(ItemUseType.CONSUME, Arrays.asList(new ItemStack((IItemProvider)item, ((Integer)state.func_177229_b((Property)TurtleEggBlock.field_203171_b)).intValue())));
        }
        if (block instanceof SeaPickleBlock) {
            return new ItemRequirement(ItemUseType.CONSUME, Arrays.asList(new ItemStack((IItemProvider)item, ((Integer)state.func_177229_b((Property)SeaPickleBlock.field_204902_a)).intValue())));
        }
        if (block instanceof SnowBlock) {
            return new ItemRequirement(ItemUseType.CONSUME, Arrays.asList(new ItemStack((IItemProvider)item, ((Integer)state.func_177229_b((Property)SnowBlock.field_176315_a)).intValue())));
        }
        if (block instanceof GrassPathBlock) {
            return new ItemRequirement(ItemUseType.CONSUME, Arrays.asList(new ItemStack((IItemProvider)Items.field_221581_i)));
        }
        if (block instanceof FarmlandBlock) {
            return new ItemRequirement(ItemUseType.CONSUME, Arrays.asList(new ItemStack((IItemProvider)Items.field_221582_j)));
        }
        return item == Items.field_190931_a ? INVALID : new ItemRequirement(ItemUseType.CONSUME, item);
    }

    public static ItemRequirement of(Entity entity) {
        EntityType type = entity.func_200600_R();
        if (entity instanceof ISpecialEntityItemRequirement) {
            return ((ISpecialEntityItemRequirement)entity).getRequiredItems();
        }
        if (type == EntityType.field_200766_F) {
            ItemFrameEntity ife = (ItemFrameEntity)entity;
            ItemStack frame = new ItemStack((IItemProvider)Items.field_151160_bD);
            ItemStack displayedItem = ife.func_82335_i();
            if (displayedItem.func_190926_b()) {
                return new ItemRequirement(ItemUseType.CONSUME, Items.field_151160_bD);
            }
            return new ItemRequirement(ItemUseType.CONSUME, Arrays.asList(frame, displayedItem));
        }
        if (type == EntityType.field_200782_V) {
            return new ItemRequirement(ItemUseType.CONSUME, Items.field_151159_an);
        }
        if (type == EntityType.field_200789_c) {
            ArrayList<ItemStack> requirements = new ArrayList<ItemStack>();
            ArmorStandEntity armorStandEntity = (ArmorStandEntity)entity;
            armorStandEntity.func_184209_aF().forEach(requirements::add);
            requirements.add(new ItemStack((IItemProvider)Items.field_179565_cj));
            return new ItemRequirement(ItemUseType.CONSUME, requirements);
        }
        if (entity instanceof AbstractMinecartEntity) {
            AbstractMinecartEntity minecartEntity = (AbstractMinecartEntity)entity;
            return new ItemRequirement(ItemUseType.CONSUME, minecartEntity.getCartItem().func_77973_b());
        }
        if (entity instanceof BoatEntity) {
            BoatEntity boatEntity = (BoatEntity)entity;
            return new ItemRequirement(ItemUseType.CONSUME, boatEntity.func_184455_j().getItem());
        }
        if (type == EntityType.field_200801_o) {
            return new ItemRequirement(ItemUseType.CONSUME, Items.field_185158_cP);
        }
        return INVALID;
    }

    public boolean isEmpty() {
        return NONE == this;
    }

    public boolean isInvalid() {
        return INVALID == this;
    }

    public List<ItemStack> getRequiredItems() {
        return this.requiredItems;
    }

    public ItemUseType getUsage() {
        return this.usage;
    }

    public static boolean validate(ItemStack required, ItemStack present) {
        return required.func_190926_b() || required.func_77973_b() == present.func_77973_b();
    }

    public static enum ItemUseType {
        CONSUME,
        DAMAGE;

    }
}

