/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.advancement;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.simibubi.create.foundation.advancement.CriterionTriggerBase;
import com.simibubi.create.foundation.advancement.ITriggerable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class StringSerializableTrigger<T>
extends CriterionTriggerBase<Instance<T>> {
    protected String getJsonKey() {
        return "accepted_entries";
    }

    protected StringSerializableTrigger(String id) {
        super(id);
    }

    @SafeVarargs
    public final Instance<T> forEntries(T ... entries) {
        return new Instance(this, entries == null ? null : Sets.newHashSet((Object[])entries));
    }

    public void trigger(ServerPlayerEntity player, @Nullable T registryEntry) {
        this.trigger(player, (T)Collections.singletonList(() -> registryEntry));
    }

    public ITriggerable constructTriggerFor(@Nullable T entry) {
        return player -> this.trigger(player, entry);
    }

    public Instance<T> conditionsFromJson(JsonObject json, ConditionArrayParser context) {
        if (json.has(this.getJsonKey())) {
            JsonArray elements = json.getAsJsonArray(this.getJsonKey());
            return new Instance(this, StreamSupport.stream(elements.spliterator(), false).map(JsonElement::getAsString).map(key -> {
                T entry = this.getValue((String)key);
                if (entry == null) {
                    throw new JsonSyntaxException("Unknown entry '" + key + "'");
                }
                return entry;
            }).collect(Collectors.toSet()));
        }
        return new Instance(this, null);
    }

    @Nullable
    protected abstract T getValue(String var1);

    @Nullable
    protected abstract String getKey(T var1);

    public static class Instance<T>
    extends CriterionTriggerBase.Instance {
        @Nullable
        private final Set<T> entries;
        private final StringSerializableTrigger<T> trigger;

        public Instance(StringSerializableTrigger<T> trigger, @Nullable Set<T> entries) {
            super(trigger.func_192163_a(), EntityPredicate.AndPredicate.field_234582_a_);
            this.trigger = trigger;
            this.entries = entries;
        }

        @Override
        protected boolean test(@Nullable List<Supplier<Object>> suppliers) {
            if (this.entries == null || suppliers == null || suppliers.isEmpty()) {
                return false;
            }
            return this.entries.contains(suppliers.get(0).get());
        }

        public JsonObject func_230240_a_(ConditionArraySerializer p_230240_1_) {
            JsonObject jsonobject = super.func_230240_a_(p_230240_1_);
            JsonArray elements = new JsonArray();
            if (this.entries == null) {
                jsonobject.add(this.trigger.getJsonKey(), (JsonElement)elements);
                return jsonobject;
            }
            for (T entry : this.entries) {
                String key;
                if (entry == null || (key = this.trigger.getKey(entry)) == null) continue;
                elements.add(key);
            }
            jsonobject.add(this.trigger.getJsonKey(), (JsonElement)elements);
            return jsonobject;
        }
    }
}

