/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data.recipe;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeSerializer;
import com.simibubi.create.foundation.data.recipe.CompactingRecipeGen;
import com.simibubi.create.foundation.data.recipe.CreateRecipeProvider;
import com.simibubi.create.foundation.data.recipe.CrushingRecipeGen;
import com.simibubi.create.foundation.data.recipe.CuttingRecipeGen;
import com.simibubi.create.foundation.data.recipe.EmptyingRecipeGen;
import com.simibubi.create.foundation.data.recipe.FillingRecipeGen;
import com.simibubi.create.foundation.data.recipe.MillingRecipeGen;
import com.simibubi.create.foundation.data.recipe.MixingRecipeGen;
import com.simibubi.create.foundation.data.recipe.PolishingRecipeGen;
import com.simibubi.create.foundation.data.recipe.PressingRecipeGen;
import com.simibubi.create.foundation.data.recipe.WashingRecipeGen;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;

public abstract class ProcessingRecipeGen
extends CreateRecipeProvider {
    protected static List<ProcessingRecipeGen> generators = new ArrayList<ProcessingRecipeGen>();
    protected static final int BUCKET = 1000;
    protected static final int BOTTLE = 250;

    public static void registerAll(DataGenerator gen) {
        generators.add(new CrushingRecipeGen(gen));
        generators.add(new MillingRecipeGen(gen));
        generators.add(new CuttingRecipeGen(gen));
        generators.add(new WashingRecipeGen(gen));
        generators.add(new PolishingRecipeGen(gen));
        generators.add(new MixingRecipeGen(gen));
        generators.add(new CompactingRecipeGen(gen));
        generators.add(new PressingRecipeGen(gen));
        generators.add(new FillingRecipeGen(gen));
        generators.add(new EmptyingRecipeGen(gen));
        gen.func_200390_a(new IDataProvider(){

            public String func_200397_b() {
                return "Create's Processing Recipes";
            }

            public void func_200398_a(DirectoryCache dc) throws IOException {
                generators.forEach(g -> {
                    try {
                        g.func_200398_a(dc);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
        });
    }

    public ProcessingRecipeGen(DataGenerator p_i48262_1_) {
        super(p_i48262_1_);
    }

    protected <T extends ProcessingRecipe<?>> CreateRecipeProvider.GeneratedRecipe create(Supplier<IItemProvider> singleIngredient, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        ProcessingRecipeSerializer serializer = this.getSerializer();
        CreateRecipeProvider.GeneratedRecipe generatedRecipe = c -> {
            IItemProvider iItemProvider = (IItemProvider)singleIngredient.get();
            ((ProcessingRecipeBuilder)transform.apply(new ProcessingRecipeBuilder(serializer.getFactory(), Create.asResource(iItemProvider.func_199767_j().getRegistryName().func_110623_a())).withItemIngredients(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{iItemProvider})))).build(c);
        };
        this.all.add(generatedRecipe);
        return generatedRecipe;
    }

    protected <T extends ProcessingRecipe<?>> CreateRecipeProvider.GeneratedRecipe create(String name, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        ProcessingRecipeSerializer serializer = this.getSerializer();
        CreateRecipeProvider.GeneratedRecipe generatedRecipe = c -> ((ProcessingRecipeBuilder)transform.apply(new ProcessingRecipeBuilder(serializer.getFactory(), Create.asResource(name)))).build(c);
        this.all.add(generatedRecipe);
        return generatedRecipe;
    }

    private <T extends ProcessingRecipe<?>> ProcessingRecipeSerializer<T> getSerializer() {
        ProcessingRecipeSerializer serializer = (ProcessingRecipeSerializer)this.getRecipeType().serializer;
        return serializer;
    }

    public final String func_200397_b() {
        return "Create's Processing Recipes: " + (Object)((Object)this.getRecipeType());
    }

    protected abstract AllRecipeTypes getRecipeType();
}

