/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.utility.ColorHelper;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class UIRenderHelper {
    public static Framebuffer framebuffer;

    public static void init() {
        RenderSystem.recordRenderCall(() -> {
            MainWindow mainWindow = Minecraft.func_71410_x().func_228018_at_();
            framebuffer = new Framebuffer(mainWindow.func_198109_k(), mainWindow.func_198091_l(), true, Minecraft.field_142025_a);
            framebuffer.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        });
    }

    public static void prepFramebufferSize() {
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        if (UIRenderHelper.framebuffer.field_147621_c != window.func_198109_k() || UIRenderHelper.framebuffer.field_147618_d != window.func_198091_l()) {
            framebuffer.func_216491_a(window.func_198109_k(), window.func_198091_l(), Minecraft.field_142025_a);
        }
    }

    public static void drawFramebuffer(float alpha) {
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        float vx = window.func_198107_o();
        float vy = window.func_198087_p();
        float tx = (float)UIRenderHelper.framebuffer.field_147621_c / (float)UIRenderHelper.framebuffer.field_147622_a;
        float ty = (float)UIRenderHelper.framebuffer.field_147618_d / (float)UIRenderHelper.framebuffer.field_147620_b;
        RenderSystem.enableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableLighting();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        framebuffer.func_147612_c();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        bufferbuilder.func_225582_a_(0.0, (double)vy, 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)vx, (double)vy, 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(tx, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)vx, 0.0, 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(tx, ty).func_181675_d();
        bufferbuilder.func_225582_a_(0.0, 0.0, 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, ty).func_181675_d();
        tessellator.func_78381_a();
        framebuffer.func_147606_d();
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
    }

    public static void streak(MatrixStack ms, float angle, int x, int y, int width, int length, int color) {
        int a1 = -1610612736;
        int a2 = Integer.MIN_VALUE;
        int a3 = 0x10000000;
        int a4 = 0;
        int c1 = a1 | (color &= 0xFFFFFF);
        int c2 = a2 | color;
        int c3 = a3 | color;
        int c4 = a4 | color;
        ms.func_227860_a_();
        ms.func_227861_a_((double)x, (double)y, 0.0);
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(angle - 90.0f));
        UIRenderHelper.streak(ms, width / 2, length, c1, c2, c3, c4);
        ms.func_227865_b_();
    }

    private static void streak(MatrixStack ms, int width, int height, int c1, int c2, int c3, int c4) {
        double split1 = 0.5;
        double split2 = 0.75;
        Matrix4f model = ms.func_227866_c_().func_227870_a_();
        GuiUtils.drawGradientRect((Matrix4f)model, (int)0, (int)(-width), (int)0, (int)width, (int)((int)(split1 * (double)height)), (int)c1, (int)c2);
        GuiUtils.drawGradientRect((Matrix4f)model, (int)0, (int)(-width), (int)((int)(split1 * (double)height)), (int)width, (int)((int)(split2 * (double)height)), (int)c2, (int)c3);
        GuiUtils.drawGradientRect((Matrix4f)model, (int)0, (int)(-width), (int)((int)(split2 * (double)height)), (int)width, (int)height, (int)c3, (int)c4);
    }

    public static void breadcrumbArrow(MatrixStack matrixStack, int x, int y, int z, int width, int height, int indent, int startColor, int endColor) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)(x - indent), (double)y, (double)z);
        UIRenderHelper.breadcrumbArrow(matrixStack, width, height, indent, startColor, endColor);
        matrixStack.func_227865_b_();
    }

    private static void breadcrumbArrow(MatrixStack ms, int width, int height, int indent, int c1, int c2) {
        float x0 = 0.0f;
        float y0 = (float)height / 2.0f;
        float x1 = indent;
        float y1 = 0.0f;
        float x2 = indent;
        float y2 = (float)height / 2.0f;
        float x3 = indent;
        float y3 = height;
        float x4 = width;
        float y4 = 0.0f;
        float x5 = width;
        float y5 = (float)height / 2.0f;
        float x6 = width;
        float y6 = height;
        float x7 = indent + width;
        float y7 = 0.0f;
        float x8 = indent + width;
        float y8 = height;
        indent = Math.abs(indent);
        width = Math.abs(width);
        int fc1 = ColorHelper.mixAlphaColors(c1, c2, 0.0f);
        int fc2 = ColorHelper.mixAlphaColors(c1, c2, (float)indent / ((float)width + 2.0f * (float)indent));
        int fc3 = ColorHelper.mixAlphaColors(c1, c2, (float)(indent + width) / ((float)width + 2.0f * (float)indent));
        int fc4 = ColorHelper.mixAlphaColors(c1, c2, 1.0f);
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        Matrix4f model = ms.func_227866_c_().func_227870_a_();
        bufferbuilder.func_181668_a(4, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_227888_a_(model, x0, y0, 0.0f).func_225586_a_(fc1 >> 16 & 0xFF, fc1 >> 8 & 0xFF, fc1 & 0xFF, fc1 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_227888_a_(model, x1, y1, 0.0f).func_225586_a_(fc2 >> 16 & 0xFF, fc2 >> 8 & 0xFF, fc2 & 0xFF, fc2 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_227888_a_(model, x2, y2, 0.0f).func_225586_a_(fc2 >> 16 & 0xFF, fc2 >> 8 & 0xFF, fc2 & 0xFF, fc2 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_227888_a_(model, x0, y0, 0.0f).func_225586_a_(fc1 >> 16 & 0xFF, fc1 >> 8 & 0xFF, fc1 & 0xFF, fc1 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_227888_a_(model, x2, y2, 0.0f).func_225586_a_(fc2 >> 16 & 0xFF, fc2 >> 8 & 0xFF, fc2 & 0xFF, fc2 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_227888_a_(model, x3, y3, 0.0f).func_225586_a_(fc2 >> 16 & 0xFF, fc2 >> 8 & 0xFF, fc2 & 0xFF, fc2 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_227888_a_(model, x3, y3, 0.0f).func_225586_a_(fc2 >> 16 & 0xFF, fc2 >> 8 & 0xFF, fc2 & 0xFF, fc2 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_227888_a_(model, x1, y1, 0.0f).func_225586_a_(fc2 >> 16 & 0xFF, fc2 >> 8 & 0xFF, fc2 & 0xFF, fc2 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_227888_a_(model, x4, y4, 0.0f).func_225586_a_(fc3 >> 16 & 0xFF, fc3 >> 8 & 0xFF, fc3 & 0xFF, fc3 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_227888_a_(model, x3, y3, 0.0f).func_225586_a_(fc2 >> 16 & 0xFF, fc2 >> 8 & 0xFF, fc2 & 0xFF, fc2 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_227888_a_(model, x4, y4, 0.0f).func_225586_a_(fc3 >> 16 & 0xFF, fc3 >> 8 & 0xFF, fc3 & 0xFF, fc3 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_227888_a_(model, x6, y6, 0.0f).func_225586_a_(fc3 >> 16 & 0xFF, fc3 >> 8 & 0xFF, fc3 & 0xFF, fc3 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_227888_a_(model, x5, y5, 0.0f).func_225586_a_(fc3 >> 16 & 0xFF, fc3 >> 8 & 0xFF, fc3 & 0xFF, fc3 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_227888_a_(model, x4, y4, 0.0f).func_225586_a_(fc3 >> 16 & 0xFF, fc3 >> 8 & 0xFF, fc3 & 0xFF, fc3 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_227888_a_(model, x7, y7, 0.0f).func_225586_a_(fc4 >> 16 & 0xFF, fc4 >> 8 & 0xFF, fc4 & 0xFF, fc4 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_227888_a_(model, x6, y6, 0.0f).func_225586_a_(fc3 >> 16 & 0xFF, fc3 >> 8 & 0xFF, fc3 & 0xFF, fc3 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_227888_a_(model, x5, y5, 0.0f).func_225586_a_(fc3 >> 16 & 0xFF, fc3 >> 8 & 0xFF, fc3 & 0xFF, fc3 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_227888_a_(model, x8, y8, 0.0f).func_225586_a_(fc4 >> 16 & 0xFF, fc4 >> 8 & 0xFF, fc4 & 0xFF, fc4 >> 24 & 0xFF).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }
}

