/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.foundation.renderState.RenderTypes;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class PartialItemModelRenderer {
    static PartialItemModelRenderer instance;
    ItemStack stack;
    int overlay;
    MatrixStack ms;
    ItemCameraTransforms.TransformType transformType;
    IRenderTypeBuffer buffer;

    static PartialItemModelRenderer get() {
        if (instance == null) {
            instance = new PartialItemModelRenderer();
        }
        return instance;
    }

    public static PartialItemModelRenderer of(ItemStack stack, ItemCameraTransforms.TransformType transformType, MatrixStack ms, IRenderTypeBuffer buffer, int overlay) {
        PartialItemModelRenderer instance = PartialItemModelRenderer.get();
        instance.stack = stack;
        instance.buffer = buffer;
        instance.ms = ms;
        instance.transformType = transformType;
        instance.overlay = overlay;
        return instance;
    }

    public void render(IBakedModel model, int light) {
        this.render(model, RenderTypes.getItemPartialTranslucent(), light);
    }

    public void renderSolid(IBakedModel model, int light) {
        this.render(model, RenderTypes.getItemPartialSolid(), light);
    }

    public void renderSolidGlowing(IBakedModel model, int light) {
        this.render(model, RenderTypes.getGlowingSolid(), light);
    }

    public void renderGlowing(IBakedModel model, int light) {
        this.render(model, RenderTypes.getGlowingTranslucent(), light);
    }

    public void render(IBakedModel model, RenderType type, int light) {
        if (this.stack.func_190926_b()) {
            return;
        }
        this.ms.func_227860_a_();
        this.ms.func_227861_a_(-0.5, -0.5, -0.5);
        if (!model.func_188618_c()) {
            this.renderBakedItemModel(model, light, this.ms, ItemRenderer.func_239386_a_((IRenderTypeBuffer)this.buffer, (RenderType)type, (boolean)true, (boolean)this.stack.func_77962_s()));
        } else {
            this.stack.func_77973_b().getItemStackTileEntityRenderer().func_239207_a_(this.stack, this.transformType, this.ms, this.buffer, light, this.overlay);
        }
        this.ms.func_227865_b_();
    }

    private void renderBakedItemModel(IBakedModel model, int light, MatrixStack ms, IVertexBuilder p_229114_6_) {
        ItemRenderer ir = Minecraft.func_71410_x().func_175599_af();
        Random random = new Random();
        EmptyModelData data = EmptyModelData.INSTANCE;
        for (Direction direction : Iterate.directions) {
            random.setSeed(42L);
            ir.func_229112_a_(ms, p_229114_6_, model.getQuads(null, direction, random, (IModelData)data), this.stack, light, this.overlay);
        }
        random.setSeed(42L);
        ir.func_229112_a_(ms, p_229114_6_, model.getQuads(null, null, random, (IModelData)data), this.stack, light, this.overlay);
    }
}

