/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.elements.PonderSceneElement;
import com.simibubi.create.foundation.utility.MatrixStacker;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public abstract class AnimatedSceneElement
extends PonderSceneElement {
    protected Vector3d fadeVec;
    protected LerpedFloat fade = LerpedFloat.linear().startWithValue(0.0);

    public void forceApplyFade(float fade) {
        this.fade.startWithValue(fade);
    }

    public void setFade(float fade) {
        this.fade.setValue(fade);
    }

    public void setFadeVec(Vector3d fadeVec) {
        this.fadeVec = fadeVec;
    }

    @Override
    public final void renderFirst(PonderWorld world, IRenderTypeBuffer buffer, MatrixStack ms, float pt) {
        ms.func_227860_a_();
        float currentFade = this.applyFade(ms, pt);
        this.renderFirst(world, buffer, ms, currentFade, pt);
        ms.func_227865_b_();
    }

    @Override
    public final void renderLayer(PonderWorld world, IRenderTypeBuffer buffer, RenderType type, MatrixStack ms, float pt) {
        ms.func_227860_a_();
        float currentFade = this.applyFade(ms, pt);
        this.renderLayer(world, buffer, type, ms, currentFade, pt);
        ms.func_227865_b_();
    }

    @Override
    public final void renderLast(PonderWorld world, IRenderTypeBuffer buffer, MatrixStack ms, float pt) {
        ms.func_227860_a_();
        float currentFade = this.applyFade(ms, pt);
        this.renderLast(world, buffer, ms, currentFade, pt);
        ms.func_227865_b_();
    }

    protected float applyFade(MatrixStack ms, float pt) {
        float currentFade = this.fade.getValue(pt);
        if (this.fadeVec != null) {
            MatrixStacker.of(ms).translate(this.fadeVec.func_186678_a((double)(-1.0f + currentFade)));
        }
        return currentFade;
    }

    protected void renderLayer(PonderWorld world, IRenderTypeBuffer buffer, RenderType type, MatrixStack ms, float fade, float pt) {
    }

    protected void renderFirst(PonderWorld world, IRenderTypeBuffer buffer, MatrixStack ms, float fade, float pt) {
    }

    protected void renderLast(PonderWorld world, IRenderTypeBuffer buffer, MatrixStack ms, float fade, float pt) {
    }

    protected int lightCoordsFromFade(float fade) {
        int light = 0xF000F0;
        if (fade != 1.0f) {
            light = (int)MathHelper.func_219799_g((float)fade, (float)5.0f, (float)15.0f);
            light = light << 4 | light << 20;
        }
        return light;
    }
}

