/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render.backend.core;

import com.simibubi.create.foundation.render.backend.core.BasicData;
import com.simibubi.create.foundation.render.backend.instancing.InstancedModel;
import java.nio.ByteBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class OrientedData
extends BasicData {
    private float posX;
    private float posY;
    private float posZ;
    private float pivotX = 0.5f;
    private float pivotY = 0.5f;
    private float pivotZ = 0.5f;
    private float qX;
    private float qY;
    private float qZ;
    private float qW;

    public OrientedData(InstancedModel<?> owner) {
        super(owner);
    }

    public OrientedData setPosition(BlockPos pos) {
        return this.setPosition(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public OrientedData setPosition(Vector3f pos) {
        return this.setPosition(pos.func_195899_a(), pos.func_195900_b(), pos.func_195902_c());
    }

    public OrientedData setPosition(float x, float y, float z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.markDirty();
        return this;
    }

    public OrientedData nudge(float x, float y, float z) {
        this.posX += x;
        this.posY += y;
        this.posZ += z;
        this.markDirty();
        return this;
    }

    public OrientedData setPivot(Vector3f pos) {
        return this.setPosition(pos.func_195899_a(), pos.func_195900_b(), pos.func_195902_c());
    }

    public OrientedData setPivot(Vector3d pos) {
        return this.setPosition((float)pos.func_82615_a(), (float)pos.func_82617_b(), (float)pos.func_82616_c());
    }

    public OrientedData setPivot(float x, float y, float z) {
        this.pivotX = x;
        this.pivotY = y;
        this.pivotZ = z;
        this.markDirty();
        return this;
    }

    public OrientedData setRotation(Quaternion q) {
        return this.setRotation(q.func_195889_a(), q.func_195891_b(), q.func_195893_c(), q.func_195894_d());
    }

    public OrientedData setRotation(float x, float y, float z, float w) {
        this.qX = x;
        this.qY = y;
        this.qZ = z;
        this.qW = w;
        this.markDirty();
        return this;
    }

    @Override
    public void write(ByteBuffer buf) {
        super.write(buf);
        buf.asFloatBuffer().put(new float[]{this.posX, this.posY, this.posZ, this.pivotX, this.pivotY, this.pivotZ, this.qX, this.qY, this.qZ, this.qW});
        buf.position(buf.position() + 40);
    }
}

