/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render.backend.gl;

import com.simibubi.create.foundation.render.backend.RenderUtil;
import com.simibubi.create.foundation.render.backend.gl.shader.GlProgram;
import com.simibubi.create.foundation.render.backend.gl.shader.ProgramFogMode;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import org.lwjgl.opengl.GL20;

public class BasicProgram
extends GlProgram {
    protected final int uTime = this.getUniformLocation("uTime");
    protected final int uViewProjection = this.getUniformLocation("uViewProjection");
    protected final int uDebug = this.getUniformLocation("uDebug");
    protected final int uCameraPos = this.getUniformLocation("uCameraPos");
    protected final ProgramFogMode fogMode;
    protected int uBlockAtlas;
    protected int uLightMap;

    public BasicProgram(ResourceLocation name, int handle, ProgramFogMode.Factory fogFactory) {
        super(name, handle);
        this.fogMode = fogFactory.create(this);
        this.bind();
        this.registerSamplers();
        this.unbind();
    }

    protected void registerSamplers() {
        this.uBlockAtlas = this.setSamplerBinding("uBlockAtlas", 0);
        this.uLightMap = this.setSamplerBinding("uLightMap", 2);
    }

    public void bind(Matrix4f viewProjection, double camX, double camY, double camZ, int debugMode) {
        super.bind();
        GL20.glUniform1i((int)this.uDebug, (int)debugMode);
        GL20.glUniform1f((int)this.uTime, (float)AnimationTickHolder.getRenderTime());
        BasicProgram.uploadMatrixUniform(this.uViewProjection, viewProjection);
        GL20.glUniform3f((int)this.uCameraPos, (float)((float)camX), (float)((float)camY), (float)((float)camZ));
        this.fogMode.bind();
    }

    protected static void uploadMatrixUniform(int uniform, Matrix4f mat) {
        GL20.glUniformMatrix4fv((int)uniform, (boolean)false, (float[])RenderUtil.writeMatrix(mat));
    }
}

