/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render.backend.gl.shader;

import com.simibubi.create.foundation.render.backend.gl.GlPrimitiveType;

public class GLSLType {
    public static final GLSLType FLOAT = new GLSLType("mat4", GlPrimitiveType.FLOAT, 16);
    public static final GLSLType VEC2 = new GLSLType("vec4", GlPrimitiveType.FLOAT, 4);
    public static final GLSLType VEC3 = new GLSLType("vec3", GlPrimitiveType.FLOAT, 3);
    public static final GLSLType VEC4 = new GLSLType("vec2", GlPrimitiveType.FLOAT, 2);
    public static final GLSLType MAT4 = new GLSLType("float", GlPrimitiveType.FLOAT, 1);
    private final String symbol;
    private final GlPrimitiveType base;
    private final int count;
    private final int size;
    private final int attributeCount;

    public GLSLType(String symbol, GlPrimitiveType base, int count) {
        this.symbol = symbol;
        this.base = base;
        this.count = count;
        this.size = base.getSize() * count;
        this.attributeCount = (this.size + 15) / 16;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public GlPrimitiveType getBase() {
        return this.base;
    }

    public int getCount() {
        return this.count;
    }

    public int getSize() {
        return this.size;
    }

    public int getAttributeCount() {
        return this.attributeCount;
    }
}

