/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render.backend.gl.shader;

import com.simibubi.create.foundation.render.backend.Backend;
import com.simibubi.create.foundation.render.backend.gl.GlFogMode;
import com.simibubi.create.foundation.render.backend.gl.GlObject;
import com.simibubi.create.foundation.render.backend.gl.attrib.IVertexAttrib;
import com.simibubi.create.foundation.render.backend.gl.shader.GlShader;
import com.simibubi.create.foundation.render.backend.gl.shader.ProgramFogMode;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL20;

public abstract class GlProgram
extends GlObject {
    public final ResourceLocation name;

    protected GlProgram(ResourceLocation name, int handle) {
        this.setHandle(handle);
        this.name = name;
    }

    public static Builder builder(ResourceLocation name, GlFogMode fogMode) {
        return new Builder(name, fogMode);
    }

    public void bind() {
        GL20.glUseProgram((int)this.handle());
    }

    public void unbind() {
        GL20.glUseProgram((int)0);
    }

    public int getUniformLocation(String uniform) {
        int index = GL20.glGetUniformLocation((int)this.handle(), (CharSequence)uniform);
        if (index < 0) {
            Backend.log.debug("No active uniform '{}' exists in program '{}'. Could be unused.", (Object)uniform, (Object)this.name);
        }
        return index;
    }

    public int setSamplerBinding(String name, int binding) {
        int samplerUniform = this.getUniformLocation(name);
        if (samplerUniform >= 0) {
            GL20.glUniform1i((int)samplerUniform, (int)binding);
        }
        return samplerUniform;
    }

    @Override
    protected void deleteInternal(int handle) {
        GL20.glDeleteProgram((int)handle);
    }

    @FunctionalInterface
    public static interface ProgramFactory<P extends GlProgram> {
        public P create(ResourceLocation var1, int var2, ProgramFogMode.Factory var3);
    }

    public static class Builder {
        private final ResourceLocation name;
        private final int program;
        private final GlFogMode fogMode;
        private int attributeIndex;

        public Builder(ResourceLocation name, GlFogMode fogMode) {
            this.name = name;
            this.program = GL20.glCreateProgram();
            this.fogMode = fogMode;
        }

        public Builder attachShader(GlShader shader) {
            GL20.glAttachShader((int)this.program, (int)shader.handle());
            return this;
        }

        public <A extends IVertexAttrib> Builder addAttribute(A attrib) {
            GL20.glBindAttribLocation((int)this.program, (int)this.attributeIndex, (CharSequence)attrib.attribName());
            this.attributeIndex += attrib.attribSpec().getAttributeCount();
            return this;
        }

        public <P extends GlProgram> P build(ProgramFactory<P> factory) {
            int result;
            GL20.glLinkProgram((int)this.program);
            String log = GL20.glGetProgramInfoLog((int)this.program);
            if (!log.isEmpty()) {
                Backend.log.debug("Program link log for " + this.name + ": " + log);
            }
            if ((result = GL20.glGetProgrami((int)this.program, (int)35714)) != 1) {
                throw new RuntimeException("Shader program linking failed, see log for details");
            }
            return factory.create(this.name, this.program, this.fogMode.getFogFactory());
        }
    }
}

