/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render.backend.gl.shader;

import com.simibubi.create.foundation.render.backend.Backend;
import com.simibubi.create.foundation.render.backend.gl.GlObject;
import com.simibubi.create.foundation.render.backend.gl.shader.ShaderType;
import com.simibubi.create.foundation.render.backend.gl.versioned.GlCompat;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL20;

public class GlShader
extends GlObject {
    public final ResourceLocation name;
    public final ShaderType type;

    public GlShader(ShaderType type, ResourceLocation name, String source) {
        this.type = type;
        this.name = name;
        int handle = GL20.glCreateShader((int)type.glEnum);
        GlCompat.safeShaderSource(handle, source);
        GL20.glCompileShader((int)handle);
        String log = GL20.glGetShaderInfoLog((int)handle);
        if (!log.isEmpty()) {
            Backend.log.error("Shader compilation log for " + name + ": " + log);
        }
        if (GL20.glGetShaderi((int)handle, (int)35713) != 1) {
            throw new RuntimeException("Could not compile shader. See log for details.");
        }
        this.setHandle(handle);
    }

    @Override
    protected void deleteInternal(int handle) {
        GL20.glDeleteShader((int)handle);
    }

    @FunctionalInterface
    public static interface PreProcessor {
        public String process(String var1);

        default public PreProcessor andThen(PreProcessor that) {
            return source -> that.process(this.process(source));
        }
    }
}

