/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render.backend.instancing.util;

import com.simibubi.create.foundation.render.backend.instancing.InstanceData;
import com.simibubi.create.foundation.render.backend.instancing.InstancedModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

public class SelectInstance<D extends InstanceData> {
    final List<InstancedModel<D>> models = new ArrayList<InstancedModel<D>>();
    ModelSelector selector;
    private int last = -1;
    @Nullable
    private D current;

    public SelectInstance(ModelSelector selector) {
        this.selector = selector;
    }

    public SelectInstance<D> addModel(InstancedModel<D> model) {
        this.models.add(model);
        return this;
    }

    public SelectInstance<D> update() {
        int i = this.selector.modelIndexToShow();
        if (i < 0 || i >= this.models.size()) {
            if (this.current != null) {
                ((InstanceData)this.current).delete();
                this.current = null;
            }
        } else if (i != this.last) {
            if (this.current != null) {
                ((InstanceData)this.current).delete();
            }
            this.current = this.models.get(i).createInstance();
        }
        this.last = i;
        return this;
    }

    public Optional<D> get() {
        return Optional.ofNullable(this.current);
    }

    public void delete() {
        if (this.current != null) {
            ((InstanceData)this.current).delete();
        }
    }

    public static interface ModelSelector {
        public int modelIndexToShow();
    }
}

